// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MongoCluster
{
    internal class MongoClusterFirewallRuleOperationSource : IOperationSource<MongoClusterFirewallRuleResource>
    {
        private readonly ArmClient _client;

        internal MongoClusterFirewallRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        MongoClusterFirewallRuleResource IOperationSource<MongoClusterFirewallRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MongoClusterFirewallRuleData.DeserializeMongoClusterFirewallRuleData(document.RootElement);
            return new MongoClusterFirewallRuleResource(_client, data);
        }

        async ValueTask<MongoClusterFirewallRuleResource> IOperationSource<MongoClusterFirewallRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MongoClusterFirewallRuleData.DeserializeMongoClusterFirewallRuleData(document.RootElement);
            return new MongoClusterFirewallRuleResource(_client, data);
        }
    }
}
