// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.MongoCluster.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMongoClusterArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMongoClusterArmClient"/> class for mocking. </summary>
        protected MockableMongoClusterArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMongoClusterArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMongoClusterArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMongoClusterArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="MongoClusterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MongoClusterResource.CreateResourceIdentifier" /> to create a <see cref="MongoClusterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MongoClusterResource"/> object. </returns>
        public virtual MongoClusterResource GetMongoClusterResource(ResourceIdentifier id)
        {
            MongoClusterResource.ValidateResourceId(id);
            return new MongoClusterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MongoClusterFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MongoClusterFirewallRuleResource.CreateResourceIdentifier" /> to create a <see cref="MongoClusterFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MongoClusterFirewallRuleResource"/> object. </returns>
        public virtual MongoClusterFirewallRuleResource GetMongoClusterFirewallRuleResource(ResourceIdentifier id)
        {
            MongoClusterFirewallRuleResource.ValidateResourceId(id);
            return new MongoClusterFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MongoClusterPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MongoClusterPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="MongoClusterPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MongoClusterPrivateEndpointConnectionResource"/> object. </returns>
        public virtual MongoClusterPrivateEndpointConnectionResource GetMongoClusterPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            MongoClusterPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new MongoClusterPrivateEndpointConnectionResource(Client, id);
        }
    }
}
