// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmMongoClusterModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterReplica"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="Models.MongoClusterReplica"/> instance for mocking. </returns>
        public static MongoClusterReplica MongoClusterReplica(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MongoClusterProperties properties = null)
        {
            return new MongoClusterReplica(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterProperties"/>. </summary>
        /// <param name="createMode"> The mode to create a mongo cluster. </param>
        /// <param name="restoreParameters"> The parameters to create a point-in-time restore mongo cluster. </param>
        /// <param name="replicaParameters"> The parameters to create a replica mongo cluster. </param>
        /// <param name="administrator"> The local administrator properties for the mongo cluster. </param>
        /// <param name="serverVersion"> The Mongo DB server version. Defaults to the latest available version if not specified. </param>
        /// <param name="connectionString"> The default mongo connection string for the cluster. </param>
        /// <param name="provisioningState"> The provisioning state of the mongo cluster. </param>
        /// <param name="clusterStatus"> The status of the mongo cluster. </param>
        /// <param name="publicNetworkAccess"> Whether or not public endpoint access is allowed for this mongo cluster. </param>
        /// <param name="highAvailabilityTargetMode"> The high availability properties of the mongo cluster. </param>
        /// <param name="storageSizeGb"> The storage properties of the mongo cluster. </param>
        /// <param name="shardingShardCount"> The sharding properties of the mongo cluster. </param>
        /// <param name="computeTier"> The compute properties of the mongo cluster. </param>
        /// <param name="backupEarliestRestoreTime"> The backup properties of the mongo cluster. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="previewFeatures"> List of private endpoint connections. </param>
        /// <param name="replica"> The replication properties for the mongo cluster. </param>
        /// <param name="infrastructureVersion"> The infrastructure version the cluster is provisioned on. </param>
        /// <returns> A new <see cref="Models.MongoClusterProperties"/> instance for mocking. </returns>
        public static MongoClusterProperties MongoClusterProperties(MongoClusterCreateMode? createMode = null, MongoClusterRestoreContent restoreParameters = null, MongoClusterReplicaContent replicaParameters = null, MongoClusterAdministratorProperties administrator = null, string serverVersion = null, string connectionString = null, MongoClusterProvisioningState? provisioningState = null, MongoClusterStatus? clusterStatus = null, MongoClusterPublicNetworkAccess? publicNetworkAccess = null, HighAvailabilityMode? highAvailabilityTargetMode = null, long? storageSizeGb = null, int? shardingShardCount = null, string computeTier = null, string backupEarliestRestoreTime = null, IEnumerable<MongoClusterPrivateEndpointConnection> privateEndpointConnections = null, IEnumerable<MongoClusterPreviewFeature> previewFeatures = null, MongoClusterReplicationProperties replica = null, string infrastructureVersion = null)
        {
            privateEndpointConnections ??= new List<MongoClusterPrivateEndpointConnection>();
            previewFeatures ??= new List<MongoClusterPreviewFeature>();

            return new MongoClusterProperties(
                createMode,
                restoreParameters,
                replicaParameters,
                administrator,
                serverVersion,
                connectionString,
                provisioningState,
                clusterStatus,
                publicNetworkAccess,
                highAvailabilityTargetMode != null ? new HighAvailabilityProperties(highAvailabilityTargetMode, serializedAdditionalRawData: null) : null,
                storageSizeGb != null ? new StorageProperties(storageSizeGb, serializedAdditionalRawData: null) : null,
                shardingShardCount != null ? new ShardingProperties(shardingShardCount, serializedAdditionalRawData: null) : null,
                computeTier != null ? new ComputeProperties(computeTier, serializedAdditionalRawData: null) : null,
                backupEarliestRestoreTime != null ? new BackupProperties(backupEarliestRestoreTime, serializedAdditionalRawData: null) : null,
                privateEndpointConnections?.ToList(),
                previewFeatures?.ToList(),
                replica,
                infrastructureVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterPrivateEndpointConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The private endpoint connection properties. </param>
        /// <returns> A new <see cref="Models.MongoClusterPrivateEndpointConnection"/> instance for mocking. </returns>
        public static MongoClusterPrivateEndpointConnection MongoClusterPrivateEndpointConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MongoClusterPrivateEndpointConnectionProperties properties = null)
        {
            return new MongoClusterPrivateEndpointConnection(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterPrivateEndpointConnectionProperties"/>. </summary>
        /// <param name="groupIds"> The group ids for the private endpoint resource. </param>
        /// <param name="privateEndpointId"> The private endpoint resource. </param>
        /// <param name="privateLinkServiceConnectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="Models.MongoClusterPrivateEndpointConnectionProperties"/> instance for mocking. </returns>
        public static MongoClusterPrivateEndpointConnectionProperties MongoClusterPrivateEndpointConnectionProperties(IEnumerable<string> groupIds = null, ResourceIdentifier privateEndpointId = null, MongoClusterPrivateLinkServiceConnectionState privateLinkServiceConnectionState = null, MongoClusterPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            groupIds ??= new List<string>();

            return new MongoClusterPrivateEndpointConnectionProperties(groupIds?.ToList(), privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null, privateLinkServiceConnectionState, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterReplicationProperties"/>. </summary>
        /// <param name="sourceResourceId"> The resource id the source cluster for the replica cluster. </param>
        /// <param name="role"> The replication role of the cluster. </param>
        /// <param name="replicationState"> The replication link state of the replica cluster. </param>
        /// <returns> A new <see cref="Models.MongoClusterReplicationProperties"/> instance for mocking. </returns>
        public static MongoClusterReplicationProperties MongoClusterReplicationProperties(ResourceIdentifier sourceResourceId = null, MongoClusterReplicationRole? role = null, MongoClusterReplicationState? replicationState = null)
        {
            return new MongoClusterReplicationProperties(sourceResourceId, role, replicationState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="Models.MongoClusterPrivateLinkResourceData"/> instance for mocking. </returns>
        public static MongoClusterPrivateLinkResourceData MongoClusterPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MongoClusterPrivateLinkResourceProperties properties = null)
        {
            return new MongoClusterPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterPrivateLinkResourceProperties"/>. </summary>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource private link DNS zone name. </param>
        /// <returns> A new <see cref="Models.MongoClusterPrivateLinkResourceProperties"/> instance for mocking. </returns>
        public static MongoClusterPrivateLinkResourceProperties MongoClusterPrivateLinkResourceProperties(string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new MongoClusterPrivateLinkResourceProperties(groupId, requiredMembers?.ToList(), requiredZoneNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MongoCluster.MongoClusterPrivateEndpointConnectionResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="MongoCluster.MongoClusterPrivateEndpointConnectionResourceData"/> instance for mocking. </returns>
        public static MongoClusterPrivateEndpointConnectionResourceData MongoClusterPrivateEndpointConnectionResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MongoClusterPrivateEndpointConnectionProperties properties = null)
        {
            return new MongoClusterPrivateEndpointConnectionResourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MongoCluster.MongoClusterFirewallRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="MongoCluster.MongoClusterFirewallRuleData"/> instance for mocking. </returns>
        public static MongoClusterFirewallRuleData MongoClusterFirewallRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MongoClusterFirewallRuleProperties properties = null)
        {
            return new MongoClusterFirewallRuleData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterFirewallRuleProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the firewall rule. </param>
        /// <param name="startIPAddress"> The start IP address of the mongo cluster firewall rule. Must be IPv4 format. </param>
        /// <param name="endIPAddress"> The end IP address of the mongo cluster firewall rule. Must be IPv4 format. </param>
        /// <returns> A new <see cref="Models.MongoClusterFirewallRuleProperties"/> instance for mocking. </returns>
        public static MongoClusterFirewallRuleProperties MongoClusterFirewallRuleProperties(MongoClusterProvisioningState? provisioningState = null, string startIPAddress = null, string endIPAddress = null)
        {
            return new MongoClusterFirewallRuleProperties(provisioningState, startIPAddress, endIPAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MongoCluster.MongoClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="MongoCluster.MongoClusterData"/> instance for mocking. </returns>
        public static MongoClusterData MongoClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MongoClusterProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MongoClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterConnectionStringsResult"/>. </summary>
        /// <param name="connectionStrings"> An array that contains the connection strings for a mongo cluster. </param>
        /// <returns> A new <see cref="Models.MongoClusterConnectionStringsResult"/> instance for mocking. </returns>
        public static MongoClusterConnectionStringsResult MongoClusterConnectionStringsResult(IEnumerable<MongoClusterConnectionString> connectionStrings = null)
        {
            connectionStrings ??= new List<MongoClusterConnectionString>();

            return new MongoClusterConnectionStringsResult(connectionStrings?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterConnectionString"/>. </summary>
        /// <param name="uri"> Value of the connection string. </param>
        /// <param name="description"> Description of the connection string. </param>
        /// <param name="name"> Name of the connection string. </param>
        /// <returns> A new <see cref="Models.MongoClusterConnectionString"/> instance for mocking. </returns>
        public static MongoClusterConnectionString MongoClusterConnectionString(string uri = null, string description = null, string name = null)
        {
            return new MongoClusterConnectionString(uri, description, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoClusterNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is not available. </param>
        /// <returns> A new <see cref="Models.MongoClusterNameAvailabilityResult"/> instance for mocking. </returns>
        public static MongoClusterNameAvailabilityResult MongoClusterNameAvailabilityResult(bool? isNameAvailable = null, MongoClusterNameUnavailableReason? reason = null, string message = null)
        {
            return new MongoClusterNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PromoteReplicaContent"/>. </summary>
        /// <param name="promoteOption"> The promote option to apply to the operation. </param>
        /// <param name="mode"> The mode to apply to the promote operation. Value is optional and default value is 'Switchover'. </param>
        /// <returns> A new <see cref="Models.PromoteReplicaContent"/> instance for mocking. </returns>
        public static PromoteReplicaContent PromoteReplicaContent(MongoClusterPromoteOption promoteOption = default, MongoClusterPromoteMode? mode = null)
        {
            return new PromoteReplicaContent(promoteOption, mode, serializedAdditionalRawData: null);
        }
    }
}
