// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MongoCluster.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.MongoCluster.Samples
{
    public partial class Sample_MongoClusterResource
    {
        // Gets a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_Get.json
            // this example is just showing the usage of "MongoCluster_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterResource result = await mongoCluster.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates the disk size on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesTheDiskSizeOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PatchDiskSize.json
            // this example is just showing the usage of "MongoCluster_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterPatch patch = new MongoClusterPatch()
            {
                Properties = new MongoClusterUpdateProperties()
                {
                    StorageSizeGb = 256L,
                },
            };
            ArmOperation<MongoClusterResource> lro = await mongoCluster.UpdateAsync(WaitUntil.Completed, patch);
            MongoClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Disables public network access on a Mongo Cluster resource with a private endpoint connection.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_DisablesPublicNetworkAccessOnAMongoClusterResourceWithAPrivateEndpointConnection()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PatchPrivateNetworkAccess.json
            // this example is just showing the usage of "MongoCluster_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterPatch patch = new MongoClusterPatch()
            {
                Properties = new MongoClusterUpdateProperties()
                {
                    PublicNetworkAccess = MongoClusterPublicNetworkAccess.Disabled,
                },
            };
            ArmOperation<MongoClusterResource> lro = await mongoCluster.UpdateAsync(WaitUntil.Completed, patch);
            MongoClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resets the administrator login password.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ResetsTheAdministratorLoginPassword()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_ResetPassword.json
            // this example is just showing the usage of "MongoCluster_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterPatch patch = new MongoClusterPatch()
            {
                Properties = new MongoClusterUpdateProperties()
                {
                    Administrator = new MongoClusterAdministratorProperties()
                    {
                        UserName = "mongoAdmin",
                        Password = "password",
                    },
                },
            };
            ArmOperation<MongoClusterResource> lro = await mongoCluster.UpdateAsync(WaitUntil.Completed, patch);
            MongoClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates a Mongo Cluster resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_Update.json
            // this example is just showing the usage of "MongoCluster_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterPatch patch = new MongoClusterPatch()
            {
                Properties = new MongoClusterUpdateProperties()
                {
                    Administrator = new MongoClusterAdministratorProperties()
                    {
                        UserName = "mongoAdmin",
                    },
                    ServerVersion = "5.0",
                    PublicNetworkAccess = MongoClusterPublicNetworkAccess.Enabled,
                    HighAvailabilityTargetMode = HighAvailabilityMode.SameZone,
                    StorageSizeGb = 256L,
                    ShardingShardCount = 4,
                    ComputeTier = "M50",
                    PreviewFeatures =
{
},
                },
            };
            ArmOperation<MongoClusterResource> lro = await mongoCluster.UpdateAsync(WaitUntil.Completed, patch);
            MongoClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_Delete.json
            // this example is just showing the usage of "MongoCluster_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestResourceGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            await mongoCluster.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Lists the Mongo Cluster resources in a subscription.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMongoClusters_ListsTheMongoClusterResourcesInASubscription()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_List.json
            // this example is just showing the usage of "MongoCluster_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MongoClusterResource item in subscriptionResource.GetMongoClustersAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MongoClusterData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List the available connection strings for the Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetConnectionStrings_ListTheAvailableConnectionStringsForTheMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_ListConnectionStrings.json
            // this example is just showing the usage of "MongoClusters_ListConnectionStrings" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            MongoClusterConnectionStringsResult result = await mongoCluster.GetConnectionStringsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Checks and confirms the Mongo Cluster name is availability for use.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckMongoClusterNameAvailability_ChecksAndConfirmsTheMongoClusterNameIsAvailabilityForUse()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_NameAvailability.json
            // this example is just showing the usage of "MongoClusters_CheckMongoClusterNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("westus2");
            MongoClusterNameAvailabilityContent content = new MongoClusterNameAvailabilityContent()
            {
                Name = "newmongocluster",
                ResourceType = "Microsoft.DocumentDB/mongoClusters",
            };
            MongoClusterNameAvailabilityResult result = await subscriptionResource.CheckMongoClusterNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Checks and returns that the Mongo Cluster name is already in-use.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckMongoClusterNameAvailability_ChecksAndReturnsThatTheMongoClusterNameIsAlreadyInUse()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_NameAvailability_AlreadyExists.json
            // this example is just showing the usage of "MongoClusters_CheckMongoClusterNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("westus2");
            MongoClusterNameAvailabilityContent content = new MongoClusterNameAvailabilityContent()
            {
                Name = "existingmongocluster",
                ResourceType = "Microsoft.DocumentDB/mongoClusters",
            };
            MongoClusterNameAvailabilityResult result = await subscriptionResource.CheckMongoClusterNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Promotes a replica Mongo Cluster resource to a primary role.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Promote_PromotesAReplicaMongoClusterResourceToAPrimaryRole()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_ForcePromoteReplica.json
            // this example is just showing the usage of "MongoClusters_Promote" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation
            PromoteReplicaContent content = new PromoteReplicaContent(MongoClusterPromoteOption.Forced)
            {
                Mode = MongoClusterPromoteMode.Switchover,
            };
            await mongoCluster.PromoteAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Lists the private link resources available on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetPrivateLinks_ListsThePrivateLinkResourcesAvailableOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateLinkResourceList.json
            // this example is just showing the usage of "PrivateLinkResource_ListByMongoCluster" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (MongoClusterPrivateLinkResourceData item in mongoCluster.GetPrivateLinksAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List the replicas linked to a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetReplicasByParent_ListTheReplicasLinkedToAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_ReplicaList.json
            // this example is just showing the usage of "Replica_ListByParent" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (MongoClusterReplica item in mongoCluster.GetReplicasByParentAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
