// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MongoCluster.Models;

namespace Azure.ResourceManager.MongoCluster.Samples
{
    public partial class Sample_MongoClusterPrivateEndpointConnectionResourceCollection
    {
        // Lists the private endpoint connection resources on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListsThePrivateEndpointConnectionResourcesOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionList.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_ListByMongoCluster" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // get the collection of this MongoClusterPrivateEndpointConnectionResource
            MongoClusterPrivateEndpointConnectionResourceCollection collection = mongoCluster.GetMongoClusterPrivateEndpointConnectionResources();

            // invoke the operation and iterate over the result
            await foreach (MongoClusterPrivateEndpointConnectionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MongoClusterPrivateEndpointConnectionResourceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionGet.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // get the collection of this MongoClusterPrivateEndpointConnectionResource
            MongoClusterPrivateEndpointConnectionResourceCollection collection = mongoCluster.GetMongoClusterPrivateEndpointConnectionResources();

            // invoke the operation
            string privateEndpointConnectionName = "pecTest.5d393f64-ef64-46d0-9959-308321c44ac0";
            MongoClusterPrivateEndpointConnectionResource result = await collection.GetAsync(privateEndpointConnectionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterPrivateEndpointConnectionResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionGet.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // get the collection of this MongoClusterPrivateEndpointConnectionResource
            MongoClusterPrivateEndpointConnectionResourceCollection collection = mongoCluster.GetMongoClusterPrivateEndpointConnectionResources();

            // invoke the operation
            string privateEndpointConnectionName = "pecTest.5d393f64-ef64-46d0-9959-308321c44ac0";
            bool result = await collection.ExistsAsync(privateEndpointConnectionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionGet.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // get the collection of this MongoClusterPrivateEndpointConnectionResource
            MongoClusterPrivateEndpointConnectionResourceCollection collection = mongoCluster.GetMongoClusterPrivateEndpointConnectionResources();

            // invoke the operation
            string privateEndpointConnectionName = "pecTest.5d393f64-ef64-46d0-9959-308321c44ac0";
            NullableResponse<MongoClusterPrivateEndpointConnectionResource> response = await collection.GetIfExistsAsync(privateEndpointConnectionName);
            MongoClusterPrivateEndpointConnectionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MongoClusterPrivateEndpointConnectionResourceData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Approves a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ApprovesAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionPut.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterResource created on azure
            // for more information of creating MongoClusterResource, please refer to the document of MongoClusterResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            ResourceIdentifier mongoClusterResourceId = MongoClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName);
            MongoClusterResource mongoCluster = client.GetMongoClusterResource(mongoClusterResourceId);

            // get the collection of this MongoClusterPrivateEndpointConnectionResource
            MongoClusterPrivateEndpointConnectionResourceCollection collection = mongoCluster.GetMongoClusterPrivateEndpointConnectionResources();

            // invoke the operation
            string privateEndpointConnectionName = "pecTest";
            MongoClusterPrivateEndpointConnectionResourceData data = new MongoClusterPrivateEndpointConnectionResourceData()
            {
                Properties = new MongoClusterPrivateEndpointConnectionProperties(new MongoClusterPrivateLinkServiceConnectionState()
                {
                    Status = MongoClusterPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Auto-Approved",
                }),
            };
            ArmOperation<MongoClusterPrivateEndpointConnectionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, privateEndpointConnectionName, data);
            MongoClusterPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterPrivateEndpointConnectionResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
