// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MongoCluster.Models;

namespace Azure.ResourceManager.MongoCluster.Samples
{
    public partial class Sample_MongoClusterPrivateEndpointConnectionResource
    {
        // Get a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionGet.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterPrivateEndpointConnectionResource created on azure
            // for more information of creating MongoClusterPrivateEndpointConnectionResource, please refer to the document of MongoClusterPrivateEndpointConnectionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            string privateEndpointConnectionName = "pecTest.5d393f64-ef64-46d0-9959-308321c44ac0";
            ResourceIdentifier mongoClusterPrivateEndpointConnectionResourceId = MongoClusterPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName, privateEndpointConnectionName);
            MongoClusterPrivateEndpointConnectionResource mongoClusterPrivateEndpointConnectionResource = client.GetMongoClusterPrivateEndpointConnectionResource(mongoClusterPrivateEndpointConnectionResourceId);

            // invoke the operation
            MongoClusterPrivateEndpointConnectionResource result = await mongoClusterPrivateEndpointConnectionResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterPrivateEndpointConnectionResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Approves a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApprovesAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionPut.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterPrivateEndpointConnectionResource created on azure
            // for more information of creating MongoClusterPrivateEndpointConnectionResource, please refer to the document of MongoClusterPrivateEndpointConnectionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            string privateEndpointConnectionName = "pecTest";
            ResourceIdentifier mongoClusterPrivateEndpointConnectionResourceId = MongoClusterPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName, privateEndpointConnectionName);
            MongoClusterPrivateEndpointConnectionResource mongoClusterPrivateEndpointConnectionResource = client.GetMongoClusterPrivateEndpointConnectionResource(mongoClusterPrivateEndpointConnectionResourceId);

            // invoke the operation
            MongoClusterPrivateEndpointConnectionResourceData data = new MongoClusterPrivateEndpointConnectionResourceData()
            {
                Properties = new MongoClusterPrivateEndpointConnectionProperties(new MongoClusterPrivateLinkServiceConnectionState()
                {
                    Status = MongoClusterPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Auto-Approved",
                }),
            };
            ArmOperation<MongoClusterPrivateEndpointConnectionResource> lro = await mongoClusterPrivateEndpointConnectionResource.UpdateAsync(WaitUntil.Completed, data);
            MongoClusterPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MongoClusterPrivateEndpointConnectionResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a private endpoint connection on a Mongo Cluster resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAPrivateEndpointConnectionOnAMongoClusterResource()
        {
            // Generated from example definition: 2024-07-01/MongoClusters_PrivateEndpointConnectionDelete.json
            // this example is just showing the usage of "PrivateEndpointConnectionResource_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoClusterPrivateEndpointConnectionResource created on azure
            // for more information of creating MongoClusterPrivateEndpointConnectionResource, please refer to the document of MongoClusterPrivateEndpointConnectionResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "TestGroup";
            string mongoClusterName = "myMongoCluster";
            string privateEndpointConnectionName = "pecTest.5d393f64-ef64-46d0-9959-308321c44ac0";
            ResourceIdentifier mongoClusterPrivateEndpointConnectionResourceId = MongoClusterPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, mongoClusterName, privateEndpointConnectionName);
            MongoClusterPrivateEndpointConnectionResource mongoClusterPrivateEndpointConnectionResource = client.GetMongoClusterPrivateEndpointConnectionResource(mongoClusterPrivateEndpointConnectionResourceId);

            // invoke the operation
            await mongoClusterPrivateEndpointConnectionResource.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
