// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    /// <summary>
    /// A class representing the PacketCoreControlPlaneVersion data model.
    /// Packet core control plane version resource.
    /// Serialized Name: PacketCoreControlPlaneVersion
    /// </summary>
    public partial class PacketCoreControlPlaneVersionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PacketCoreControlPlaneVersionData"/>. </summary>
        public PacketCoreControlPlaneVersionData()
        {
            Platforms = new ChangeTrackingList<MobileNetworkPlatform>();
        }

        /// <summary> Initializes a new instance of <see cref="PacketCoreControlPlaneVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the packet core control plane version resource.
        /// Serialized Name: PacketCoreControlPlaneVersion.properties.provisioningState
        /// </param>
        /// <param name="platforms">
        /// Platform specific packet core control plane version properties.
        /// Serialized Name: PacketCoreControlPlaneVersion.properties.platforms
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PacketCoreControlPlaneVersionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, MobileNetworkProvisioningState? provisioningState, IList<MobileNetworkPlatform> platforms, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            Platforms = platforms;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The provisioning state of the packet core control plane version resource.
        /// Serialized Name: PacketCoreControlPlaneVersion.properties.provisioningState
        /// </summary>
        [WirePath("properties.provisioningState")]
        public MobileNetworkProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// Platform specific packet core control plane version properties.
        /// Serialized Name: PacketCoreControlPlaneVersion.properties.platforms
        /// </summary>
        [WirePath("properties.platforms")]
        public IList<MobileNetworkPlatform> Platforms { get; }
    }
}
