// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.MobileNetwork.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.MobileNetwork
{
    public partial class PacketCoreControlPlaneData : IUtf8JsonSerializable, IJsonModel<PacketCoreControlPlaneData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PacketCoreControlPlaneData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PacketCoreControlPlaneData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCoreControlPlaneData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(UserAssignedIdentity))
            {
                writer.WritePropertyName("identity"u8);
                writer.WriteObjectValue(UserAssignedIdentity, options);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(Installation))
            {
                writer.WritePropertyName("installation"u8);
                writer.WriteObjectValue(Installation, options);
            }
            writer.WritePropertyName("sites"u8);
            writer.WriteStartArray();
            foreach (var item in Sites)
            {
                JsonSerializer.Serialize(writer, item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("platform"u8);
            writer.WriteObjectValue(Platform, options);
            if (Optional.IsDefined(CoreNetworkTechnology))
            {
                writer.WritePropertyName("coreNetworkTechnology"u8);
                writer.WriteStringValue(CoreNetworkTechnology.Value.ToSerialString());
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (options.Format != "W" && Optional.IsDefined(InstalledVersion))
            {
                writer.WritePropertyName("installedVersion"u8);
                writer.WriteStringValue(InstalledVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(RollbackVersion))
            {
                writer.WritePropertyName("rollbackVersion"u8);
                writer.WriteStringValue(RollbackVersion);
            }
            writer.WritePropertyName("controlPlaneAccessInterface"u8);
            writer.WriteObjectValue(ControlPlaneAccessInterface, options);
            if (Optional.IsCollectionDefined(ControlPlaneAccessVirtualIPv4Addresses))
            {
                writer.WritePropertyName("controlPlaneAccessVirtualIpv4Addresses"u8);
                writer.WriteStartArray();
                foreach (var item in ControlPlaneAccessVirtualIPv4Addresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("sku"u8);
            writer.WriteStringValue(Sku.ToString());
            if (Optional.IsDefined(UEMtu))
            {
                writer.WritePropertyName("ueMtu"u8);
                writer.WriteNumberValue(UEMtu.Value);
            }
            writer.WritePropertyName("localDiagnosticsAccess"u8);
            writer.WriteObjectValue(LocalDiagnosticsAccess, options);
            if (Optional.IsDefined(DiagnosticsUpload))
            {
                writer.WritePropertyName("diagnosticsUpload"u8);
                writer.WriteObjectValue(DiagnosticsUpload, options);
            }
            if (Optional.IsDefined(EventHub))
            {
                writer.WritePropertyName("eventHub"u8);
                writer.WriteObjectValue(EventHub, options);
            }
            if (Optional.IsDefined(Signaling))
            {
                writer.WritePropertyName("signaling"u8);
                writer.WriteObjectValue(Signaling, options);
            }
            if (Optional.IsDefined(InteropSettings))
            {
                writer.WritePropertyName("interopSettings"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(InteropSettings);
#else
                using (JsonDocument document = JsonDocument.Parse(InteropSettings))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (options.Format != "W" && Optional.IsDefined(HomeNetworkPrivateKeysProvisioning))
            {
                writer.WritePropertyName("homeNetworkPrivateKeysProvisioning"u8);
                writer.WriteObjectValue(HomeNetworkPrivateKeysProvisioning, options);
            }
            if (Optional.IsDefined(UserConsent))
            {
                writer.WritePropertyName("userConsent"u8);
                writer.WriteObjectValue(UserConsent, options);
            }
            writer.WriteEndObject();
        }

        PacketCoreControlPlaneData IJsonModel<PacketCoreControlPlaneData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCoreControlPlaneData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePacketCoreControlPlaneData(document.RootElement, options);
        }

        internal static PacketCoreControlPlaneData DeserializePacketCoreControlPlaneData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MobileNetworkManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            MobileNetworkProvisioningState? provisioningState = default;
            MobileNetworkInstallation installation = default;
            IList<WritableSubResource> sites = default;
            MobileNetworkPlatformConfiguration platform = default;
            MobileNetworkCoreNetworkType? coreNetworkTechnology = default;
            string version = default;
            string installedVersion = default;
            string rollbackVersion = default;
            MobileNetworkInterfaceProperties controlPlaneAccessInterface = default;
            IList<string> controlPlaneAccessVirtualIPv4Addresses = default;
            MobileNetworkBillingSku sku = default;
            int? ueMtu = default;
            MobileNetworkLocalDiagnosticsAccessConfiguration localDiagnosticsAccess = default;
            DiagnosticsUploadConfiguration diagnosticsUpload = default;
            MobileNetworkEventHubConfiguration eventHub = default;
            PacketCoreSignalingConfiguration signaling = default;
            BinaryData interopSettings = default;
            HomeNetworkPrivateKeysProvisioning homeNetworkPrivateKeysProvisioning = default;
            UserConsentConfiguration userConsent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = MobileNetworkManagedServiceIdentity.DeserializeMobileNetworkManagedServiceIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new MobileNetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("installation"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            installation = MobileNetworkInstallation.DeserializeMobileNetworkInstallation(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("sites"u8))
                        {
                            List<WritableSubResource> array = new List<WritableSubResource>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(JsonSerializer.Deserialize<WritableSubResource>(item.GetRawText()));
                            }
                            sites = array;
                            continue;
                        }
                        if (property0.NameEquals("platform"u8))
                        {
                            platform = MobileNetworkPlatformConfiguration.DeserializeMobileNetworkPlatformConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("coreNetworkTechnology"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            coreNetworkTechnology = property0.Value.GetString().ToMobileNetworkCoreNetworkType();
                            continue;
                        }
                        if (property0.NameEquals("version"u8))
                        {
                            version = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("installedVersion"u8))
                        {
                            installedVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("rollbackVersion"u8))
                        {
                            rollbackVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("controlPlaneAccessInterface"u8))
                        {
                            controlPlaneAccessInterface = MobileNetworkInterfaceProperties.DeserializeMobileNetworkInterfaceProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("controlPlaneAccessVirtualIpv4Addresses"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            controlPlaneAccessVirtualIPv4Addresses = array;
                            continue;
                        }
                        if (property0.NameEquals("sku"u8))
                        {
                            sku = new MobileNetworkBillingSku(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("ueMtu"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ueMtu = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("localDiagnosticsAccess"u8))
                        {
                            localDiagnosticsAccess = MobileNetworkLocalDiagnosticsAccessConfiguration.DeserializeMobileNetworkLocalDiagnosticsAccessConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("diagnosticsUpload"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            diagnosticsUpload = DiagnosticsUploadConfiguration.DeserializeDiagnosticsUploadConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("eventHub"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            eventHub = MobileNetworkEventHubConfiguration.DeserializeMobileNetworkEventHubConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("signaling"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            signaling = PacketCoreSignalingConfiguration.DeserializePacketCoreSignalingConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("interopSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            interopSettings = BinaryData.FromString(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("homeNetworkPrivateKeysProvisioning"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            homeNetworkPrivateKeysProvisioning = HomeNetworkPrivateKeysProvisioning.DeserializeHomeNetworkPrivateKeysProvisioning(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("userConsent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            userConsent = UserConsentConfiguration.DeserializeUserConsentConfiguration(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PacketCoreControlPlaneData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                identity,
                provisioningState,
                installation,
                sites,
                platform,
                coreNetworkTechnology,
                version,
                installedVersion,
                rollbackVersion,
                controlPlaneAccessInterface,
                controlPlaneAccessVirtualIPv4Addresses ?? new ChangeTrackingList<string>(),
                sku,
                ueMtu,
                localDiagnosticsAccess,
                diagnosticsUpload,
                eventHub,
                signaling,
                interopSettings,
                homeNetworkPrivateKeysProvisioning,
                userConsent,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserAssignedIdentity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UserAssignedIdentity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UserAssignedIdentity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Installation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    installation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Installation))
                {
                    builder.Append("    installation: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Installation, options, 4, false, "    installation: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sites), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sites: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Sites))
                {
                    if (Sites.Any())
                    {
                        builder.Append("    sites: ");
                        builder.AppendLine("[");
                        foreach (var item in Sites)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    sites: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Platform), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    platform: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Platform))
                {
                    builder.Append("    platform: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Platform, options, 4, false, "    platform: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CoreNetworkTechnology), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    coreNetworkTechnology: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CoreNetworkTechnology))
                {
                    builder.Append("    coreNetworkTechnology: ");
                    builder.AppendLine($"'{CoreNetworkTechnology.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Version), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    version: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Version))
                {
                    builder.Append("    version: ");
                    if (Version.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Version}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Version}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstalledVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    installedVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InstalledVersion))
                {
                    builder.Append("    installedVersion: ");
                    if (InstalledVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InstalledVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InstalledVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RollbackVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    rollbackVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RollbackVersion))
                {
                    builder.Append("    rollbackVersion: ");
                    if (RollbackVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RollbackVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RollbackVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ControlPlaneAccessInterface), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    controlPlaneAccessInterface: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ControlPlaneAccessInterface))
                {
                    builder.Append("    controlPlaneAccessInterface: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ControlPlaneAccessInterface, options, 4, false, "    controlPlaneAccessInterface: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ControlPlaneAccessVirtualIPv4Addresses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    controlPlaneAccessVirtualIpv4Addresses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ControlPlaneAccessVirtualIPv4Addresses))
                {
                    if (ControlPlaneAccessVirtualIPv4Addresses.Any())
                    {
                        builder.Append("    controlPlaneAccessVirtualIpv4Addresses: ");
                        builder.AppendLine("[");
                        foreach (var item in ControlPlaneAccessVirtualIPv4Addresses)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("    sku: ");
                builder.AppendLine($"'{Sku.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UEMtu), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ueMtu: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UEMtu))
                {
                    builder.Append("    ueMtu: ");
                    builder.AppendLine($"{UEMtu.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LocalDiagnosticsAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    localDiagnosticsAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LocalDiagnosticsAccess))
                {
                    builder.Append("    localDiagnosticsAccess: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LocalDiagnosticsAccess, options, 4, false, "    localDiagnosticsAccess: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("DiagnosticsUploadStorageAccountContainerUri", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    diagnosticsUpload: ");
                builder.AppendLine("{");
                builder.AppendLine("      diagnosticsUpload: {");
                builder.Append("        storageAccountContainerUrl: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(DiagnosticsUpload))
                {
                    builder.Append("    diagnosticsUpload: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DiagnosticsUpload, options, 4, false, "    diagnosticsUpload: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EventHub), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    eventHub: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EventHub))
                {
                    builder.Append("    eventHub: ");
                    BicepSerializationHelpers.AppendChildObject(builder, EventHub, options, 4, false, "    eventHub: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Signaling), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    signaling: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Signaling))
                {
                    builder.Append("    signaling: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Signaling, options, 4, false, "    signaling: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InteropSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    interopSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InteropSettings))
                {
                    builder.Append("    interopSettings: ");
                    builder.AppendLine($"'{InteropSettings.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("HomeNetworkPrivateKeysProvisioningState", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    homeNetworkPrivateKeysProvisioning: ");
                builder.AppendLine("{");
                builder.AppendLine("      homeNetworkPrivateKeysProvisioning: {");
                builder.Append("        state: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(HomeNetworkPrivateKeysProvisioning))
                {
                    builder.Append("    homeNetworkPrivateKeysProvisioning: ");
                    BicepSerializationHelpers.AppendChildObject(builder, HomeNetworkPrivateKeysProvisioning, options, 4, false, "    homeNetworkPrivateKeysProvisioning: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("AllowSupportTelemetryAccess", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userConsent: ");
                builder.AppendLine("{");
                builder.AppendLine("      userConsent: {");
                builder.Append("        allowSupportTelemetryAccess: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(UserConsent))
                {
                    builder.Append("    userConsent: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UserConsent, options, 4, false, "    userConsent: ");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PacketCoreControlPlaneData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PacketCoreControlPlaneData)} does not support writing '{options.Format}' format.");
            }
        }

        PacketCoreControlPlaneData IPersistableModel<PacketCoreControlPlaneData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePacketCoreControlPlaneData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PacketCoreControlPlaneData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PacketCoreControlPlaneData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
