// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// UE Session Info for 5G.
    /// Serialized Name: UeSessionInfo5G
    /// </summary>
    public partial class UESessionInfo5G
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UESessionInfo5G"/>. </summary>
        /// <param name="pduSessionId">
        /// PDU session identifier
        /// Serialized Name: UeSessionInfo5G.pduSessionId
        /// </param>
        /// <param name="dnn">
        /// Data network name
        /// Serialized Name: UeSessionInfo5G.dnn
        /// </param>
        /// <param name="pdnType">
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo5G.pdnType
        /// </param>
        /// <param name="qosFlow"> Serialized Name: UeSessionInfo5G.qosFlow. </param>
        /// <param name="uplink">
        /// Uplink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.uplink
        /// </param>
        /// <param name="downlink">
        /// Downlink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.downlink
        /// </param>
        /// <param name="sst">
        /// Slice/service type (SST).
        /// Serialized Name: UeSessionInfo5G.snssai.sst
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnn"/>, <paramref name="qosFlow"/>, <paramref name="uplink"/> or <paramref name="downlink"/> is null. </exception>
        public UESessionInfo5G(int pduSessionId, string dnn, PdnType pdnType, IEnumerable<UEQosFlow> qosFlow, string uplink, string downlink, int sst)
        {
            Argument.AssertNotNull(dnn, nameof(dnn));
            Argument.AssertNotNull(qosFlow, nameof(qosFlow));
            Argument.AssertNotNull(uplink, nameof(uplink));
            Argument.AssertNotNull(downlink, nameof(downlink));

            PduSessionId = pduSessionId;
            Dnn = dnn;
            PdnType = pdnType;
            QosFlow = qosFlow.ToList();
            Uplink = uplink;
            Downlink = downlink;
            Sst = sst;
        }

        /// <summary> Initializes a new instance of <see cref="UESessionInfo5G"/>. </summary>
        /// <param name="pduSessionId">
        /// PDU session identifier
        /// Serialized Name: UeSessionInfo5G.pduSessionId
        /// </param>
        /// <param name="dnn">
        /// Data network name
        /// Serialized Name: UeSessionInfo5G.dnn
        /// </param>
        /// <param name="pdnType">
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo5G.pdnType
        /// </param>
        /// <param name="qosFlow"> Serialized Name: UeSessionInfo5G.qosFlow. </param>
        /// <param name="uplink">
        /// Uplink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.uplink
        /// </param>
        /// <param name="downlink">
        /// Downlink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.downlink
        /// </param>
        /// <param name="ipV4Addr">
        /// IPv4 address.
        /// Serialized Name: UeSessionInfo5G.ueIpAddress.ipV4Addr
        /// </param>
        /// <param name="sst">
        /// Slice/service type (SST).
        /// Serialized Name: UeSessionInfo5G.snssai.sst
        /// </param>
        /// <param name="sd">
        /// Slice differentiator (SD).
        /// Serialized Name: UeSessionInfo5G.snssai.sd
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UESessionInfo5G(int pduSessionId, string dnn, PdnType pdnType, IList<UEQosFlow> qosFlow, string uplink, string downlink, string ipV4Addr, int sst, string sd, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PduSessionId = pduSessionId;
            Dnn = dnn;
            PdnType = pdnType;
            QosFlow = qosFlow;
            Uplink = uplink;
            Downlink = downlink;
            IPV4Addr = ipV4Addr;
            Sst = sst;
            Sd = sd;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UESessionInfo5G"/> for deserialization. </summary>
        internal UESessionInfo5G()
        {
        }

        /// <summary>
        /// PDU session identifier
        /// Serialized Name: UeSessionInfo5G.pduSessionId
        /// </summary>
        [WirePath("pduSessionId")]
        public int PduSessionId { get; set; }
        /// <summary>
        /// Data network name
        /// Serialized Name: UeSessionInfo5G.dnn
        /// </summary>
        [WirePath("dnn")]
        public string Dnn { get; set; }
        /// <summary>
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo5G.pdnType
        /// </summary>
        [WirePath("pdnType")]
        public PdnType PdnType { get; set; }
        /// <summary> Serialized Name: UeSessionInfo5G.qosFlow. </summary>
        [WirePath("qosFlow")]
        public IList<UEQosFlow> QosFlow { get; }
        /// <summary>
        /// Uplink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.uplink
        /// </summary>
        [WirePath("ambr.uplink")]
        public string Uplink { get; set; }
        /// <summary>
        /// Downlink bit rate.
        /// Serialized Name: UeSessionInfo5G.ambr.downlink
        /// </summary>
        [WirePath("ambr.downlink")]
        public string Downlink { get; set; }
        /// <summary>
        /// IPv4 address.
        /// Serialized Name: UeSessionInfo5G.ueIpAddress.ipV4Addr
        /// </summary>
        [WirePath("ueIpAddress.ipV4Addr")]
        public string IPV4Addr { get; set; }
        /// <summary>
        /// Slice/service type (SST).
        /// Serialized Name: UeSessionInfo5G.snssai.sst
        /// </summary>
        [WirePath("snssai.sst")]
        public int Sst { get; set; }
        /// <summary>
        /// Slice differentiator (SD).
        /// Serialized Name: UeSessionInfo5G.snssai.sd
        /// </summary>
        [WirePath("snssai.sd")]
        public string Sd { get; set; }
    }
}
