// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// UE Session Info for 4G
    /// Serialized Name: UeSessionInfo4G
    /// </summary>
    public partial class UESessionInfo4G
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UESessionInfo4G"/>. </summary>
        /// <param name="ebi">
        /// EPS bearer identifier
        /// Serialized Name: UeSessionInfo4G.ebi
        /// </param>
        /// <param name="apn">
        /// Access point name
        /// Serialized Name: UeSessionInfo4G.apn
        /// </param>
        /// <param name="pdnType">
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo4G.pdnType
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apn"/> is null. </exception>
        public UESessionInfo4G(int ebi, string apn, PdnType pdnType)
        {
            Argument.AssertNotNull(apn, nameof(apn));

            Ebi = ebi;
            Apn = apn;
            PdnType = pdnType;
        }

        /// <summary> Initializes a new instance of <see cref="UESessionInfo4G"/>. </summary>
        /// <param name="ebi">
        /// EPS bearer identifier
        /// Serialized Name: UeSessionInfo4G.ebi
        /// </param>
        /// <param name="apn">
        /// Access point name
        /// Serialized Name: UeSessionInfo4G.apn
        /// </param>
        /// <param name="pdnType">
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo4G.pdnType
        /// </param>
        /// <param name="ipV4Addr">
        /// IPv4 address.
        /// Serialized Name: UeSessionInfo4G.ueIpAddress.ipV4Addr
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UESessionInfo4G(int ebi, string apn, PdnType pdnType, string ipV4Addr, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ebi = ebi;
            Apn = apn;
            PdnType = pdnType;
            IPV4Addr = ipV4Addr;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UESessionInfo4G"/> for deserialization. </summary>
        internal UESessionInfo4G()
        {
        }

        /// <summary>
        /// EPS bearer identifier
        /// Serialized Name: UeSessionInfo4G.ebi
        /// </summary>
        [WirePath("ebi")]
        public int Ebi { get; set; }
        /// <summary>
        /// Access point name
        /// Serialized Name: UeSessionInfo4G.apn
        /// </summary>
        [WirePath("apn")]
        public string Apn { get; set; }
        /// <summary>
        /// Packet Data Network Type
        /// Serialized Name: UeSessionInfo4G.pdnType
        /// </summary>
        [WirePath("pdnType")]
        public PdnType PdnType { get; set; }
        /// <summary>
        /// IPv4 address.
        /// Serialized Name: UeSessionInfo4G.ueIpAddress.ipV4Addr
        /// </summary>
        [WirePath("ueIpAddress.ipV4Addr")]
        public string IPV4Addr { get; set; }
    }
}
