// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class UESessionInfo4G : IUtf8JsonSerializable, IJsonModel<UESessionInfo4G>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UESessionInfo4G>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UESessionInfo4G>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UESessionInfo4G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UESessionInfo4G)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("ebi"u8);
            writer.WriteNumberValue(Ebi);
            writer.WritePropertyName("apn"u8);
            writer.WriteStringValue(Apn);
            writer.WritePropertyName("pdnType"u8);
            writer.WriteStringValue(PdnType.ToString());
            writer.WritePropertyName("ueIpAddress"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IPV4Addr))
            {
                writer.WritePropertyName("ipV4Addr"u8);
                writer.WriteStringValue(IPV4Addr);
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        UESessionInfo4G IJsonModel<UESessionInfo4G>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UESessionInfo4G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UESessionInfo4G)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUESessionInfo4G(document.RootElement, options);
        }

        internal static UESessionInfo4G DeserializeUESessionInfo4G(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int ebi = default;
            string apn = default;
            PdnType pdnType = default;
            string ipV4Addr = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ebi"u8))
                {
                    ebi = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("apn"u8))
                {
                    apn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pdnType"u8))
                {
                    pdnType = new PdnType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ueIpAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("ipV4Addr"u8))
                        {
                            ipV4Addr = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UESessionInfo4G(ebi, apn, pdnType, ipV4Addr, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Ebi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ebi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  ebi: ");
                builder.AppendLine($"{Ebi}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Apn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  apn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Apn))
                {
                    builder.Append("  apn: ");
                    if (Apn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Apn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Apn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PdnType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pdnType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  pdnType: ");
                builder.AppendLine($"'{PdnType.ToString()}'");
            }

            builder.Append("  ueIpAddress:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IPV4Addr), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ipV4Addr: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IPV4Addr))
                {
                    builder.Append("    ipV4Addr: ");
                    if (IPV4Addr.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{IPV4Addr}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{IPV4Addr}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<UESessionInfo4G>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UESessionInfo4G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(UESessionInfo4G)} does not support writing '{options.Format}' format.");
            }
        }

        UESessionInfo4G IPersistableModel<UESessionInfo4G>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UESessionInfo4G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUESessionInfo4G(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UESessionInfo4G)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UESessionInfo4G>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
