// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Response for packet core list UEs API call.
    /// Serialized Name: UeInfoList
    /// </summary>
    internal partial class UEInfoList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UEInfoList"/>. </summary>
        internal UEInfoList()
        {
            Value = new ChangeTrackingList<UEInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="UEInfoList"/>. </summary>
        /// <param name="value">
        /// A list of UEs in a packet core and their basic information.
        /// Serialized Name: UeInfoList.value
        /// </param>
        /// <param name="nextLink">
        /// The URL to get the next set of results.
        /// Serialized Name: UeInfoList.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UEInfoList(IReadOnlyList<UEInfo> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// A list of UEs in a packet core and their basic information.
        /// Serialized Name: UeInfoList.value
        /// </summary>
        public IReadOnlyList<UEInfo> Value { get; }
        /// <summary>
        /// The URL to get the next set of results.
        /// Serialized Name: UeInfoList.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
