// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// UE Information for 5G.
    /// Serialized Name: UeInfo5G
    /// </summary>
    public partial class UEInfo5G : ExtendedUEInfoProperties
    {
        /// <summary> Initializes a new instance of <see cref="UEInfo5G"/>. </summary>
        /// <param name="supi">
        /// Subscription Permanent Identifier
        /// Serialized Name: UeInfo5G.info.supi
        /// </param>
        /// <param name="fivegTmsi">
        /// 5G Temporary Mobile Subscriber Identity
        /// Serialized Name: UeInfo5G.info.fivegGuti.fivegTmsi
        /// </param>
        /// <param name="regionId">
        /// AMF region identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.regionId
        /// </param>
        /// <param name="setId">
        /// AMF set identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.setId
        /// </param>
        /// <param name="pointer">
        /// AMF pointer
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.pointer
        /// </param>
        /// <param name="mccInfoFivegGutiPlmnMcc">
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mcc
        /// </param>
        /// <param name="mncInfoFivegGutiPlmnMnc">
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mnc
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="supi"/>, <paramref name="mccInfoFivegGutiPlmnMcc"/> or <paramref name="mncInfoFivegGutiPlmnMnc"/> is null. </exception>
        public UEInfo5G(string supi, int fivegTmsi, int regionId, int setId, int pointer, string mccInfoFivegGutiPlmnMcc, string mncInfoFivegGutiPlmnMnc)
        {
            Argument.AssertNotNull(supi, nameof(supi));
            Argument.AssertNotNull(mccInfoFivegGutiPlmnMcc, nameof(mccInfoFivegGutiPlmnMcc));
            Argument.AssertNotNull(mncInfoFivegGutiPlmnMnc, nameof(mncInfoFivegGutiPlmnMnc));

            Supi = supi;
            SessionInfo = new ChangeTrackingList<UESessionInfo5G>();
            AllowedNssai = new ChangeTrackingList<Snssai>();
            FivegTmsi = fivegTmsi;
            RegionId = regionId;
            SetId = setId;
            Pointer = pointer;
            MccInfoFivegGutiPlmnMcc = mccInfoFivegGutiPlmnMcc;
            MncInfoFivegGutiPlmnMnc = mncInfoFivegGutiPlmnMnc;
            RatType = RatType.FiveG;
        }

        /// <summary> Initializes a new instance of <see cref="UEInfo5G"/>. </summary>
        /// <param name="ratType">
        /// RAT Type
        /// Serialized Name: ExtendedUeInfoProperties.ratType
        /// </param>
        /// <param name="lastReadOn">
        /// The timestamp of last UE info read from the packet core (UTC).
        /// Serialized Name: ExtendedUeInfoProperties.lastReadAt
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="supi">
        /// Subscription Permanent Identifier
        /// Serialized Name: UeInfo5G.info.supi
        /// </param>
        /// <param name="pei">
        /// Permanent Equipment Identifier
        /// Serialized Name: UeInfo5G.info.pei
        /// </param>
        /// <param name="sessionInfo"> Serialized Name: UeInfo5G.info.sessionInfo. </param>
        /// <param name="perUETnla">
        /// Per-UE transport network layer association
        /// Serialized Name: UeInfo5G.info.connectionInfo.perUeTnla
        /// </param>
        /// <param name="amfUENgapId">
        /// The AMF UE NGAP ID
        /// Serialized Name: UeInfo5G.info.connectionInfo.amfUeNgapId
        /// </param>
        /// <param name="ranUENgapId">
        /// The RAN UE NGAP ID
        /// Serialized Name: UeInfo5G.info.connectionInfo.ranUeNgapId
        /// </param>
        /// <param name="lastVisitedTai">
        /// Last Visited TAI
        /// Serialized Name: UeInfo5G.info.connectionInfo.lastVisitedTai
        /// </param>
        /// <param name="allowedNssai">
        /// Allowed Network Slice Selection Assistance Information
        /// Serialized Name: UeInfo5G.info.connectionInfo.allowedNssai
        /// </param>
        /// <param name="ueState">
        /// State of the UE.
        /// Serialized Name: UeInfo5G.info.connectionInfo.ueState
        /// </param>
        /// <param name="rrcEstablishmentCause">
        /// Radio connection establishment cause
        /// Serialized Name: UeInfo5G.info.connectionInfo.rrcEstablishmentCause
        /// </param>
        /// <param name="ueUsageSetting">
        /// The UE's usage setting
        /// Serialized Name: UeInfo5G.info.connectionInfo.ueUsageSetting
        /// </param>
        /// <param name="lastActivityOn">
        /// The timestamp of last activity of UE (UTC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.lastActivityTime
        /// </param>
        /// <param name="ngeNbId">
        /// NG-eNodeB identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.ngeNbId
        /// </param>
        /// <param name="eNbId">
        /// eNodeB identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.eNbId
        /// </param>
        /// <param name="n3IwfId">
        /// N3 IWF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.n3IwfId
        /// </param>
        /// <param name="wagfId">
        /// W-AGF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.wagfId
        /// </param>
        /// <param name="tngfId">
        /// TNGF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.tngfId
        /// </param>
        /// <param name="nid">
        /// Network identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.nid
        /// </param>
        /// <param name="bitLength"> Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.gNbId.bitLength. </param>
        /// <param name="gnbValue"> Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.gNbId.gNBValue. </param>
        /// <param name="mccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc">
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.plmnId.mcc
        /// </param>
        /// <param name="mncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc">
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.plmnId.mnc
        /// </param>
        /// <param name="locationType">
        /// Location Type
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.locationType
        /// </param>
        /// <param name="tac">
        /// Type Allocation Code of UE
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.tac
        /// </param>
        /// <param name="mccInfoConnectionInfoLocationInfoPlmnMcc">
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.plmn.mcc
        /// </param>
        /// <param name="mncInfoConnectionInfoLocationInfoPlmnMnc">
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.plmn.mnc
        /// </param>
        /// <param name="fivegTmsi">
        /// 5G Temporary Mobile Subscriber Identity
        /// Serialized Name: UeInfo5G.info.fivegGuti.fivegTmsi
        /// </param>
        /// <param name="regionId">
        /// AMF region identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.regionId
        /// </param>
        /// <param name="setId">
        /// AMF set identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.setId
        /// </param>
        /// <param name="pointer">
        /// AMF pointer
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.pointer
        /// </param>
        /// <param name="mccInfoFivegGutiPlmnMcc">
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mcc
        /// </param>
        /// <param name="mncInfoFivegGutiPlmnMnc">
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mnc
        /// </param>
        internal UEInfo5G(RatType ratType, DateTimeOffset? lastReadOn, IDictionary<string, BinaryData> serializedAdditionalRawData, string supi, string pei, IList<UESessionInfo5G> sessionInfo, string perUETnla, long? amfUENgapId, int? ranUENgapId, string lastVisitedTai, IList<Snssai> allowedNssai, UEState? ueState, RrcEstablishmentCause? rrcEstablishmentCause, UEUsageSetting? ueUsageSetting, DateTimeOffset? lastActivityOn, string ngeNbId, string eNbId, string n3IwfId, string wagfId, string tngfId, string nid, int? bitLength, string gnbValue, string mccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc, string mncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc, string locationType, string tac, string mccInfoConnectionInfoLocationInfoPlmnMcc, string mncInfoConnectionInfoLocationInfoPlmnMnc, int fivegTmsi, int regionId, int setId, int pointer, string mccInfoFivegGutiPlmnMcc, string mncInfoFivegGutiPlmnMnc) : base(ratType, lastReadOn, serializedAdditionalRawData)
        {
            Supi = supi;
            Pei = pei;
            SessionInfo = sessionInfo;
            PerUETnla = perUETnla;
            AmfUENgapId = amfUENgapId;
            RanUENgapId = ranUENgapId;
            LastVisitedTai = lastVisitedTai;
            AllowedNssai = allowedNssai;
            UEState = ueState;
            RrcEstablishmentCause = rrcEstablishmentCause;
            UEUsageSetting = ueUsageSetting;
            LastActivityOn = lastActivityOn;
            NgeNbId = ngeNbId;
            ENbId = eNbId;
            N3IwfId = n3IwfId;
            WagfId = wagfId;
            TngfId = tngfId;
            Nid = nid;
            BitLength = bitLength;
            GNBValue = gnbValue;
            MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc = mccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc;
            MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc = mncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc;
            LocationType = locationType;
            Tac = tac;
            MccInfoConnectionInfoLocationInfoPlmnMcc = mccInfoConnectionInfoLocationInfoPlmnMcc;
            MncInfoConnectionInfoLocationInfoPlmnMnc = mncInfoConnectionInfoLocationInfoPlmnMnc;
            FivegTmsi = fivegTmsi;
            RegionId = regionId;
            SetId = setId;
            Pointer = pointer;
            MccInfoFivegGutiPlmnMcc = mccInfoFivegGutiPlmnMcc;
            MncInfoFivegGutiPlmnMnc = mncInfoFivegGutiPlmnMnc;
            RatType = ratType;
        }

        /// <summary> Initializes a new instance of <see cref="UEInfo5G"/> for deserialization. </summary>
        internal UEInfo5G()
        {
        }

        /// <summary>
        /// Subscription Permanent Identifier
        /// Serialized Name: UeInfo5G.info.supi
        /// </summary>
        [WirePath("info.supi")]
        public string Supi { get; set; }
        /// <summary>
        /// Permanent Equipment Identifier
        /// Serialized Name: UeInfo5G.info.pei
        /// </summary>
        [WirePath("info.pei")]
        public string Pei { get; set; }
        /// <summary> Serialized Name: UeInfo5G.info.sessionInfo. </summary>
        [WirePath("info.sessionInfo")]
        public IList<UESessionInfo5G> SessionInfo { get; }
        /// <summary>
        /// Per-UE transport network layer association
        /// Serialized Name: UeInfo5G.info.connectionInfo.perUeTnla
        /// </summary>
        [WirePath("info.perUeTnla")]
        public string PerUETnla { get; set; }
        /// <summary>
        /// The AMF UE NGAP ID
        /// Serialized Name: UeInfo5G.info.connectionInfo.amfUeNgapId
        /// </summary>
        [WirePath("info.amfUeNgapId")]
        public long? AmfUENgapId { get; set; }
        /// <summary>
        /// The RAN UE NGAP ID
        /// Serialized Name: UeInfo5G.info.connectionInfo.ranUeNgapId
        /// </summary>
        [WirePath("info.ranUeNgapId")]
        public int? RanUENgapId { get; set; }
        /// <summary>
        /// Last Visited TAI
        /// Serialized Name: UeInfo5G.info.connectionInfo.lastVisitedTai
        /// </summary>
        [WirePath("info.lastVisitedTai")]
        public string LastVisitedTai { get; set; }
        /// <summary>
        /// Allowed Network Slice Selection Assistance Information
        /// Serialized Name: UeInfo5G.info.connectionInfo.allowedNssai
        /// </summary>
        [WirePath("info.allowedNssai")]
        public IList<Snssai> AllowedNssai { get; }
        /// <summary>
        /// State of the UE.
        /// Serialized Name: UeInfo5G.info.connectionInfo.ueState
        /// </summary>
        [WirePath("info.ueState")]
        public UEState? UEState { get; set; }
        /// <summary>
        /// Radio connection establishment cause
        /// Serialized Name: UeInfo5G.info.connectionInfo.rrcEstablishmentCause
        /// </summary>
        [WirePath("info.rrcEstablishmentCause")]
        public RrcEstablishmentCause? RrcEstablishmentCause { get; set; }
        /// <summary>
        /// The UE's usage setting
        /// Serialized Name: UeInfo5G.info.connectionInfo.ueUsageSetting
        /// </summary>
        [WirePath("info.ueUsageSetting")]
        public UEUsageSetting? UEUsageSetting { get; set; }
        /// <summary>
        /// The timestamp of last activity of UE (UTC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.lastActivityTime
        /// </summary>
        [WirePath("info.lastActivityTime")]
        public DateTimeOffset? LastActivityOn { get; set; }
        /// <summary>
        /// NG-eNodeB identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.ngeNbId
        /// </summary>
        [WirePath("info.ngeNbId")]
        public string NgeNbId { get; set; }
        /// <summary>
        /// eNodeB identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.eNbId
        /// </summary>
        [WirePath("info.eNbId")]
        public string ENbId { get; set; }
        /// <summary>
        /// N3 IWF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.n3IwfId
        /// </summary>
        [WirePath("info.n3IwfId")]
        public string N3IwfId { get; set; }
        /// <summary>
        /// W-AGF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.wagfId
        /// </summary>
        [WirePath("info.wagfId")]
        public string WagfId { get; set; }
        /// <summary>
        /// TNGF identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.tngfId
        /// </summary>
        [WirePath("info.tngfId")]
        public string TngfId { get; set; }
        /// <summary>
        /// Network identifier
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.nid
        /// </summary>
        [WirePath("info.nid")]
        public string Nid { get; set; }
        /// <summary> Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.gNbId.bitLength. </summary>
        [WirePath("info.bitLength")]
        public int? BitLength { get; set; }
        /// <summary> Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.gNbId.gNBValue. </summary>
        [WirePath("info.gNBValue")]
        public string GNBValue { get; set; }
        /// <summary>
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.plmnId.mcc
        /// </summary>
        [WirePath("info.mcc")]
        public string MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc { get; set; }
        /// <summary>
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.globalRanNodeId.plmnId.mnc
        /// </summary>
        [WirePath("info.mnc")]
        public string MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc { get; set; }
        /// <summary>
        /// Location Type
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.locationType
        /// </summary>
        [WirePath("info.locationType")]
        public string LocationType { get; set; }
        /// <summary>
        /// Type Allocation Code of UE
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.tac
        /// </summary>
        [WirePath("info.tac")]
        public string Tac { get; set; }
        /// <summary>
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.plmn.mcc
        /// </summary>
        [WirePath("info.mcc")]
        public string MccInfoConnectionInfoLocationInfoPlmnMcc { get; set; }
        /// <summary>
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.connectionInfo.locationInfo.plmn.mnc
        /// </summary>
        [WirePath("info.mnc")]
        public string MncInfoConnectionInfoLocationInfoPlmnMnc { get; set; }
        /// <summary>
        /// 5G Temporary Mobile Subscriber Identity
        /// Serialized Name: UeInfo5G.info.fivegGuti.fivegTmsi
        /// </summary>
        [WirePath("info.fivegTmsi")]
        public int FivegTmsi { get; set; }
        /// <summary>
        /// AMF region identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.regionId
        /// </summary>
        [WirePath("info.regionId")]
        public int RegionId { get; set; }
        /// <summary>
        /// AMF set identifier
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.setId
        /// </summary>
        [WirePath("info.setId")]
        public int SetId { get; set; }
        /// <summary>
        /// AMF pointer
        /// Serialized Name: UeInfo5G.info.fivegGuti.amfId.pointer
        /// </summary>
        [WirePath("info.pointer")]
        public int Pointer { get; set; }
        /// <summary>
        /// Mobile country code (MCC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mcc
        /// </summary>
        [WirePath("info.mcc")]
        public string MccInfoFivegGutiPlmnMcc { get; set; }
        /// <summary>
        /// Mobile network code (MNC).
        /// Serialized Name: UeInfo5G.info.fivegGuti.plmn.mnc
        /// </summary>
        [WirePath("info.mnc")]
        public string MncInfoFivegGutiPlmnMnc { get; set; }
    }
}
