// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class UEInfo5G : IUtf8JsonSerializable, IJsonModel<UEInfo5G>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UEInfo5G>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UEInfo5G>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo5G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UEInfo5G)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("info"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("supi"u8);
            writer.WriteStringValue(Supi);
            if (Optional.IsDefined(Pei))
            {
                writer.WritePropertyName("pei"u8);
                writer.WriteStringValue(Pei);
            }
            if (Optional.IsCollectionDefined(SessionInfo))
            {
                writer.WritePropertyName("sessionInfo"u8);
                writer.WriteStartArray();
                foreach (var item in SessionInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("connectionInfo"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(PerUETnla))
            {
                writer.WritePropertyName("perUeTnla"u8);
                writer.WriteStringValue(PerUETnla);
            }
            if (Optional.IsDefined(AmfUENgapId))
            {
                writer.WritePropertyName("amfUeNgapId"u8);
                writer.WriteNumberValue(AmfUENgapId.Value);
            }
            if (Optional.IsDefined(RanUENgapId))
            {
                writer.WritePropertyName("ranUeNgapId"u8);
                writer.WriteNumberValue(RanUENgapId.Value);
            }
            if (Optional.IsDefined(LastVisitedTai))
            {
                writer.WritePropertyName("lastVisitedTai"u8);
                writer.WriteStringValue(LastVisitedTai);
            }
            if (Optional.IsCollectionDefined(AllowedNssai))
            {
                writer.WritePropertyName("allowedNssai"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedNssai)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(UEState))
            {
                writer.WritePropertyName("ueState"u8);
                writer.WriteStringValue(UEState.Value.ToString());
            }
            if (Optional.IsDefined(RrcEstablishmentCause))
            {
                writer.WritePropertyName("rrcEstablishmentCause"u8);
                writer.WriteStringValue(RrcEstablishmentCause.Value.ToString());
            }
            if (Optional.IsDefined(UEUsageSetting))
            {
                writer.WritePropertyName("ueUsageSetting"u8);
                writer.WriteStringValue(UEUsageSetting.Value.ToString());
            }
            if (Optional.IsDefined(LastActivityOn))
            {
                writer.WritePropertyName("lastActivityTime"u8);
                writer.WriteStringValue(LastActivityOn.Value, "O");
            }
            writer.WritePropertyName("globalRanNodeId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(NgeNbId))
            {
                writer.WritePropertyName("ngeNbId"u8);
                writer.WriteStringValue(NgeNbId);
            }
            if (Optional.IsDefined(ENbId))
            {
                writer.WritePropertyName("eNbId"u8);
                writer.WriteStringValue(ENbId);
            }
            if (Optional.IsDefined(N3IwfId))
            {
                writer.WritePropertyName("n3IwfId"u8);
                writer.WriteStringValue(N3IwfId);
            }
            if (Optional.IsDefined(WagfId))
            {
                writer.WritePropertyName("wagfId"u8);
                writer.WriteStringValue(WagfId);
            }
            if (Optional.IsDefined(TngfId))
            {
                writer.WritePropertyName("tngfId"u8);
                writer.WriteStringValue(TngfId);
            }
            if (Optional.IsDefined(Nid))
            {
                writer.WritePropertyName("nid"u8);
                writer.WriteStringValue(Nid);
            }
            writer.WritePropertyName("gNbId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(BitLength))
            {
                writer.WritePropertyName("bitLength"u8);
                writer.WriteNumberValue(BitLength.Value);
            }
            if (Optional.IsDefined(GNBValue))
            {
                writer.WritePropertyName("gNBValue"u8);
                writer.WriteStringValue(GNBValue);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("plmnId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc))
            {
                writer.WritePropertyName("mcc"u8);
                writer.WriteStringValue(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc);
            }
            if (Optional.IsDefined(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc))
            {
                writer.WritePropertyName("mnc"u8);
                writer.WriteStringValue(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WritePropertyName("locationInfo"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(LocationType))
            {
                writer.WritePropertyName("locationType"u8);
                writer.WriteStringValue(LocationType);
            }
            if (Optional.IsDefined(Tac))
            {
                writer.WritePropertyName("tac"u8);
                writer.WriteStringValue(Tac);
            }
            writer.WritePropertyName("plmn"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(MccInfoConnectionInfoLocationInfoPlmnMcc))
            {
                writer.WritePropertyName("mcc"u8);
                writer.WriteStringValue(MccInfoConnectionInfoLocationInfoPlmnMcc);
            }
            if (Optional.IsDefined(MncInfoConnectionInfoLocationInfoPlmnMnc))
            {
                writer.WritePropertyName("mnc"u8);
                writer.WriteStringValue(MncInfoConnectionInfoLocationInfoPlmnMnc);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WritePropertyName("fivegGuti"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("fivegTmsi"u8);
            writer.WriteNumberValue(FivegTmsi);
            writer.WritePropertyName("amfId"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("regionId"u8);
            writer.WriteNumberValue(RegionId);
            writer.WritePropertyName("setId"u8);
            writer.WriteNumberValue(SetId);
            writer.WritePropertyName("pointer"u8);
            writer.WriteNumberValue(Pointer);
            writer.WriteEndObject();
            writer.WritePropertyName("plmn"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("mcc"u8);
            writer.WriteStringValue(MccInfoFivegGutiPlmnMcc);
            writer.WritePropertyName("mnc"u8);
            writer.WriteStringValue(MncInfoFivegGutiPlmnMnc);
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        UEInfo5G IJsonModel<UEInfo5G>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo5G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UEInfo5G)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUEInfo5G(document.RootElement, options);
        }

        internal static UEInfo5G DeserializeUEInfo5G(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RatType ratType = default;
            DateTimeOffset? lastReadAt = default;
            string supi = default;
            string pei = default;
            IList<UESessionInfo5G> sessionInfo = default;
            string perUETnla = default;
            long? amfUENgapId = default;
            int? ranUENgapId = default;
            string lastVisitedTai = default;
            IList<Snssai> allowedNssai = default;
            UEState? ueState = default;
            RrcEstablishmentCause? rrcEstablishmentCause = default;
            UEUsageSetting? ueUsageSetting = default;
            DateTimeOffset? lastActivityTime = default;
            string ngeNbId = default;
            string eNbId = default;
            string n3IwfId = default;
            string wagfId = default;
            string tngfId = default;
            string nid = default;
            int? bitLength = default;
            string gnbValue = default;
            string mcc = default;
            string mnc = default;
            string locationType = default;
            string tac = default;
            string mcc0 = default;
            string mnc0 = default;
            int fivegTmsi = default;
            int regionId = default;
            int setId = default;
            int pointer = default;
            string mcc1 = default;
            string mnc1 = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ratType"u8))
                {
                    ratType = new RatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastReadAt"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastReadAt = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("info"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("supi"u8))
                        {
                            supi = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("pei"u8))
                        {
                            pei = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sessionInfo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<UESessionInfo5G> array = new List<UESessionInfo5G>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(UESessionInfo5G.DeserializeUESessionInfo5G(item, options));
                            }
                            sessionInfo = array;
                            continue;
                        }
                        if (property0.NameEquals("connectionInfo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("perUeTnla"u8))
                                {
                                    perUETnla = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("amfUeNgapId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    amfUENgapId = property1.Value.GetInt64();
                                    continue;
                                }
                                if (property1.NameEquals("ranUeNgapId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    ranUENgapId = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("lastVisitedTai"u8))
                                {
                                    lastVisitedTai = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("allowedNssai"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    List<Snssai> array = new List<Snssai>();
                                    foreach (var item in property1.Value.EnumerateArray())
                                    {
                                        array.Add(Snssai.DeserializeSnssai(item, options));
                                    }
                                    allowedNssai = array;
                                    continue;
                                }
                                if (property1.NameEquals("ueState"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    ueState = new UEState(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("rrcEstablishmentCause"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    rrcEstablishmentCause = new RrcEstablishmentCause(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("ueUsageSetting"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    ueUsageSetting = new UEUsageSetting(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("lastActivityTime"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    lastActivityTime = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("globalRanNodeId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("ngeNbId"u8))
                                        {
                                            ngeNbId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("eNbId"u8))
                                        {
                                            eNbId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("n3IwfId"u8))
                                        {
                                            n3IwfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("wagfId"u8))
                                        {
                                            wagfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("tngfId"u8))
                                        {
                                            tngfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("nid"u8))
                                        {
                                            nid = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("gNbId"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("bitLength"u8))
                                                {
                                                    if (property3.Value.ValueKind == JsonValueKind.Null)
                                                    {
                                                        continue;
                                                    }
                                                    bitLength = property3.Value.GetInt32();
                                                    continue;
                                                }
                                                if (property3.NameEquals("gNBValue"u8))
                                                {
                                                    gnbValue = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                        if (property2.NameEquals("plmnId"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("mcc"u8))
                                                {
                                                    mcc = property3.Value.GetString();
                                                    continue;
                                                }
                                                if (property3.NameEquals("mnc"u8))
                                                {
                                                    mnc = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                                if (property1.NameEquals("locationInfo"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("locationType"u8))
                                        {
                                            locationType = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("tac"u8))
                                        {
                                            tac = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("plmn"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("mcc"u8))
                                                {
                                                    mcc0 = property3.Value.GetString();
                                                    continue;
                                                }
                                                if (property3.NameEquals("mnc"u8))
                                                {
                                                    mnc0 = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                            }
                            continue;
                        }
                        if (property0.NameEquals("fivegGuti"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("fivegTmsi"u8))
                                {
                                    fivegTmsi = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("amfId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("regionId"u8))
                                        {
                                            regionId = property2.Value.GetInt32();
                                            continue;
                                        }
                                        if (property2.NameEquals("setId"u8))
                                        {
                                            setId = property2.Value.GetInt32();
                                            continue;
                                        }
                                        if (property2.NameEquals("pointer"u8))
                                        {
                                            pointer = property2.Value.GetInt32();
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                                if (property1.NameEquals("plmn"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("mcc"u8))
                                        {
                                            mcc1 = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("mnc"u8))
                                        {
                                            mnc1 = property2.Value.GetString();
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UEInfo5G(
                ratType,
                lastReadAt,
                serializedAdditionalRawData,
                supi,
                pei,
                sessionInfo ?? new ChangeTrackingList<UESessionInfo5G>(),
                perUETnla,
                amfUENgapId,
                ranUENgapId,
                lastVisitedTai,
                allowedNssai ?? new ChangeTrackingList<Snssai>(),
                ueState,
                rrcEstablishmentCause,
                ueUsageSetting,
                lastActivityTime,
                ngeNbId,
                eNbId,
                n3IwfId,
                wagfId,
                tngfId,
                nid,
                bitLength,
                gnbValue,
                mcc,
                mnc,
                locationType,
                tac,
                mcc0,
                mnc0,
                fivegTmsi,
                regionId,
                setId,
                pointer,
                mcc1,
                mnc1);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RatType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ratType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  ratType: ");
                builder.AppendLine($"'{RatType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastReadOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastReadAt: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastReadOn))
                {
                    builder.Append("  lastReadAt: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastReadOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.Append("  info:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Supi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    supi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Supi))
                {
                    builder.Append("    supi: ");
                    if (Supi.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Supi}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Supi}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Pei), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    pei: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Pei))
                {
                    builder.Append("    pei: ");
                    if (Pei.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Pei}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Pei}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SessionInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sessionInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SessionInfo))
                {
                    if (SessionInfo.Any())
                    {
                        builder.Append("    sessionInfo: ");
                        builder.AppendLine("[");
                        foreach (var item in SessionInfo)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    sessionInfo: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.Append("    connectionInfo:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PerUETnla), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      perUeTnla: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PerUETnla))
                {
                    builder.Append("      perUeTnla: ");
                    if (PerUETnla.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PerUETnla}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PerUETnla}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmfUENgapId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      amfUeNgapId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmfUENgapId))
                {
                    builder.Append("      amfUeNgapId: ");
                    builder.AppendLine($"'{AmfUENgapId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RanUENgapId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      ranUeNgapId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RanUENgapId))
                {
                    builder.Append("      ranUeNgapId: ");
                    builder.AppendLine($"{RanUENgapId.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastVisitedTai), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      lastVisitedTai: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastVisitedTai))
                {
                    builder.Append("      lastVisitedTai: ");
                    if (LastVisitedTai.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastVisitedTai}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastVisitedTai}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowedNssai), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      allowedNssai: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AllowedNssai))
                {
                    if (AllowedNssai.Any())
                    {
                        builder.Append("      allowedNssai: ");
                        builder.AppendLine("[");
                        foreach (var item in AllowedNssai)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 8, true, "      allowedNssai: ");
                        }
                        builder.AppendLine("      ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UEState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      ueState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UEState))
                {
                    builder.Append("      ueState: ");
                    builder.AppendLine($"'{UEState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RrcEstablishmentCause), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      rrcEstablishmentCause: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RrcEstablishmentCause))
                {
                    builder.Append("      rrcEstablishmentCause: ");
                    builder.AppendLine($"'{RrcEstablishmentCause.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UEUsageSetting), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      ueUsageSetting: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UEUsageSetting))
                {
                    builder.Append("      ueUsageSetting: ");
                    builder.AppendLine($"'{UEUsageSetting.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastActivityOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      lastActivityTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastActivityOn))
                {
                    builder.Append("      lastActivityTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastActivityOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.Append("      globalRanNodeId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NgeNbId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        ngeNbId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NgeNbId))
                {
                    builder.Append("        ngeNbId: ");
                    if (NgeNbId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NgeNbId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NgeNbId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ENbId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        eNbId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ENbId))
                {
                    builder.Append("        eNbId: ");
                    if (ENbId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ENbId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ENbId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(N3IwfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        n3IwfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(N3IwfId))
                {
                    builder.Append("        n3IwfId: ");
                    if (N3IwfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{N3IwfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{N3IwfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WagfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        wagfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WagfId))
                {
                    builder.Append("        wagfId: ");
                    if (WagfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{WagfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{WagfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TngfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        tngfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TngfId))
                {
                    builder.Append("        tngfId: ");
                    if (TngfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TngfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TngfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Nid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        nid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Nid))
                {
                    builder.Append("        nid: ");
                    if (Nid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Nid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Nid}'");
                    }
                }
            }

            builder.Append("        gNbId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BitLength), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          bitLength: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BitLength))
                {
                    builder.Append("          bitLength: ");
                    builder.AppendLine($"{BitLength.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GNBValue), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          gNBValue: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GNBValue))
                {
                    builder.Append("          gNBValue: ");
                    if (GNBValue.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{GNBValue}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{GNBValue}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.Append("        plmnId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc))
                {
                    builder.Append("          mcc: ");
                    if (MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc))
                {
                    builder.Append("          mnc: ");
                    if (MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.AppendLine("      }");
            builder.Append("      locationInfo:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LocationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        locationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LocationType))
                {
                    builder.Append("        locationType: ");
                    if (LocationType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LocationType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LocationType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tac), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        tac: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Tac))
                {
                    builder.Append("        tac: ");
                    if (Tac.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Tac}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Tac}'");
                    }
                }
            }

            builder.Append("        plmn:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoConnectionInfoLocationInfoPlmnMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoConnectionInfoLocationInfoPlmnMcc))
                {
                    builder.Append("          mcc: ");
                    if (MccInfoConnectionInfoLocationInfoPlmnMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoConnectionInfoLocationInfoPlmnMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoConnectionInfoLocationInfoPlmnMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoConnectionInfoLocationInfoPlmnMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoConnectionInfoLocationInfoPlmnMnc))
                {
                    builder.Append("          mnc: ");
                    if (MncInfoConnectionInfoLocationInfoPlmnMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoConnectionInfoLocationInfoPlmnMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoConnectionInfoLocationInfoPlmnMnc}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.AppendLine("      }");
            builder.AppendLine("    }");
            builder.Append("    fivegGuti:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FivegTmsi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      fivegTmsi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("      fivegTmsi: ");
                builder.AppendLine($"{FivegTmsi}");
            }

            builder.Append("      amfId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RegionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        regionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("        regionId: ");
                builder.AppendLine($"{RegionId}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        setId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("        setId: ");
                builder.AppendLine($"{SetId}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Pointer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        pointer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("        pointer: ");
                builder.AppendLine($"{Pointer}");
            }

            builder.AppendLine("      }");
            builder.Append("      plmn:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoFivegGutiPlmnMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoFivegGutiPlmnMcc))
                {
                    builder.Append("        mcc: ");
                    if (MccInfoFivegGutiPlmnMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoFivegGutiPlmnMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoFivegGutiPlmnMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoFivegGutiPlmnMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoFivegGutiPlmnMnc))
                {
                    builder.Append("        mnc: ");
                    if (MncInfoFivegGutiPlmnMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoFivegGutiPlmnMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoFivegGutiPlmnMnc}'");
                    }
                }
            }

            builder.AppendLine("      }");
            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<UEInfo5G>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo5G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(UEInfo5G)} does not support writing '{options.Format}' format.");
            }
        }

        UEInfo5G IPersistableModel<UEInfo5G>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo5G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUEInfo5G(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UEInfo5G)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UEInfo5G>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
