// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class UEInfo4G : IUtf8JsonSerializable, IJsonModel<UEInfo4G>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UEInfo4G>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UEInfo4G>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo4G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UEInfo4G)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("info"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("imsi"u8);
            writer.WriteStringValue(Imsi);
            if (Optional.IsDefined(Imei))
            {
                writer.WritePropertyName("imei"u8);
                writer.WriteStringValue(Imei);
            }
            if (Optional.IsDefined(Imeisv))
            {
                writer.WritePropertyName("imeisv"u8);
                writer.WriteStringValue(Imeisv);
            }
            if (Optional.IsCollectionDefined(SessionInfo))
            {
                writer.WritePropertyName("sessionInfo"u8);
                writer.WriteStartArray();
                foreach (var item in SessionInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("connectionInfo"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(PerUETnla))
            {
                writer.WritePropertyName("perUeTnla"u8);
                writer.WriteStringValue(PerUETnla);
            }
            if (Optional.IsDefined(MmeS1ApId))
            {
                writer.WritePropertyName("mmeS1apId"u8);
                writer.WriteNumberValue(MmeS1ApId.Value);
            }
            if (Optional.IsDefined(EnbS1ApId))
            {
                writer.WritePropertyName("enbS1apId"u8);
                writer.WriteNumberValue(EnbS1ApId.Value);
            }
            if (Optional.IsDefined(LastVisitedTai))
            {
                writer.WritePropertyName("lastVisitedTai"u8);
                writer.WriteStringValue(LastVisitedTai);
            }
            if (Optional.IsDefined(UEState))
            {
                writer.WritePropertyName("ueState"u8);
                writer.WriteStringValue(UEState.Value.ToString());
            }
            if (Optional.IsDefined(RrcEstablishmentCause))
            {
                writer.WritePropertyName("rrcEstablishmentCause"u8);
                writer.WriteStringValue(RrcEstablishmentCause.Value.ToString());
            }
            if (Optional.IsDefined(UEUsageSetting))
            {
                writer.WritePropertyName("ueUsageSetting"u8);
                writer.WriteStringValue(UEUsageSetting.Value.ToString());
            }
            if (Optional.IsDefined(LastActivityOn))
            {
                writer.WritePropertyName("lastActivityTime"u8);
                writer.WriteStringValue(LastActivityOn.Value, "O");
            }
            writer.WritePropertyName("globalRanNodeId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(NgeNbId))
            {
                writer.WritePropertyName("ngeNbId"u8);
                writer.WriteStringValue(NgeNbId);
            }
            if (Optional.IsDefined(ENbId))
            {
                writer.WritePropertyName("eNbId"u8);
                writer.WriteStringValue(ENbId);
            }
            if (Optional.IsDefined(N3IwfId))
            {
                writer.WritePropertyName("n3IwfId"u8);
                writer.WriteStringValue(N3IwfId);
            }
            if (Optional.IsDefined(WagfId))
            {
                writer.WritePropertyName("wagfId"u8);
                writer.WriteStringValue(WagfId);
            }
            if (Optional.IsDefined(TngfId))
            {
                writer.WritePropertyName("tngfId"u8);
                writer.WriteStringValue(TngfId);
            }
            if (Optional.IsDefined(Nid))
            {
                writer.WritePropertyName("nid"u8);
                writer.WriteStringValue(Nid);
            }
            writer.WritePropertyName("gNbId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(BitLength))
            {
                writer.WritePropertyName("bitLength"u8);
                writer.WriteNumberValue(BitLength.Value);
            }
            if (Optional.IsDefined(GNBValue))
            {
                writer.WritePropertyName("gNBValue"u8);
                writer.WriteStringValue(GNBValue);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("plmnId"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc))
            {
                writer.WritePropertyName("mcc"u8);
                writer.WriteStringValue(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc);
            }
            if (Optional.IsDefined(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc))
            {
                writer.WritePropertyName("mnc"u8);
                writer.WriteStringValue(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WritePropertyName("locationInfo"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(LocationType))
            {
                writer.WritePropertyName("locationType"u8);
                writer.WriteStringValue(LocationType);
            }
            if (Optional.IsDefined(Tac))
            {
                writer.WritePropertyName("tac"u8);
                writer.WriteStringValue(Tac);
            }
            writer.WritePropertyName("plmn"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(MccInfoConnectionInfoLocationInfoPlmnMcc))
            {
                writer.WritePropertyName("mcc"u8);
                writer.WriteStringValue(MccInfoConnectionInfoLocationInfoPlmnMcc);
            }
            if (Optional.IsDefined(MncInfoConnectionInfoLocationInfoPlmnMnc))
            {
                writer.WritePropertyName("mnc"u8);
                writer.WriteStringValue(MncInfoConnectionInfoLocationInfoPlmnMnc);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WritePropertyName("guti"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("mTmsi"u8);
            writer.WriteNumberValue(MTmsi);
            writer.WritePropertyName("mmeId"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("groupId"u8);
            writer.WriteNumberValue(GroupId);
            writer.WritePropertyName("code"u8);
            writer.WriteNumberValue(Code);
            writer.WriteEndObject();
            writer.WritePropertyName("plmn"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("mcc"u8);
            writer.WriteStringValue(MccInfoGutiPlmnMcc);
            writer.WritePropertyName("mnc"u8);
            writer.WriteStringValue(MncInfoGutiPlmnMnc);
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        UEInfo4G IJsonModel<UEInfo4G>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo4G>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UEInfo4G)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUEInfo4G(document.RootElement, options);
        }

        internal static UEInfo4G DeserializeUEInfo4G(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RatType ratType = default;
            DateTimeOffset? lastReadAt = default;
            string imsi = default;
            string imei = default;
            string imeisv = default;
            IList<UESessionInfo4G> sessionInfo = default;
            string perUETnla = default;
            int? mmeS1apId = default;
            int? enbS1apId = default;
            string lastVisitedTai = default;
            UEState? ueState = default;
            RrcEstablishmentCause? rrcEstablishmentCause = default;
            UEUsageSetting? ueUsageSetting = default;
            DateTimeOffset? lastActivityTime = default;
            string ngeNbId = default;
            string eNbId = default;
            string n3IwfId = default;
            string wagfId = default;
            string tngfId = default;
            string nid = default;
            int? bitLength = default;
            string gnbValue = default;
            string mcc = default;
            string mnc = default;
            string locationType = default;
            string tac = default;
            string mcc0 = default;
            string mnc0 = default;
            int mTmsi = default;
            int groupId = default;
            int code = default;
            string mcc1 = default;
            string mnc1 = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ratType"u8))
                {
                    ratType = new RatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastReadAt"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastReadAt = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("info"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("imsi"u8))
                        {
                            imsi = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("imei"u8))
                        {
                            imei = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("imeisv"u8))
                        {
                            imeisv = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sessionInfo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<UESessionInfo4G> array = new List<UESessionInfo4G>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(UESessionInfo4G.DeserializeUESessionInfo4G(item, options));
                            }
                            sessionInfo = array;
                            continue;
                        }
                        if (property0.NameEquals("connectionInfo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("perUeTnla"u8))
                                {
                                    perUETnla = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("mmeS1apId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    mmeS1apId = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("enbS1apId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    enbS1apId = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("lastVisitedTai"u8))
                                {
                                    lastVisitedTai = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("ueState"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    ueState = new UEState(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("rrcEstablishmentCause"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    rrcEstablishmentCause = new RrcEstablishmentCause(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("ueUsageSetting"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    ueUsageSetting = new UEUsageSetting(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("lastActivityTime"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    lastActivityTime = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("globalRanNodeId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("ngeNbId"u8))
                                        {
                                            ngeNbId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("eNbId"u8))
                                        {
                                            eNbId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("n3IwfId"u8))
                                        {
                                            n3IwfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("wagfId"u8))
                                        {
                                            wagfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("tngfId"u8))
                                        {
                                            tngfId = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("nid"u8))
                                        {
                                            nid = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("gNbId"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("bitLength"u8))
                                                {
                                                    if (property3.Value.ValueKind == JsonValueKind.Null)
                                                    {
                                                        continue;
                                                    }
                                                    bitLength = property3.Value.GetInt32();
                                                    continue;
                                                }
                                                if (property3.NameEquals("gNBValue"u8))
                                                {
                                                    gnbValue = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                        if (property2.NameEquals("plmnId"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("mcc"u8))
                                                {
                                                    mcc = property3.Value.GetString();
                                                    continue;
                                                }
                                                if (property3.NameEquals("mnc"u8))
                                                {
                                                    mnc = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                                if (property1.NameEquals("locationInfo"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("locationType"u8))
                                        {
                                            locationType = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("tac"u8))
                                        {
                                            tac = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("plmn"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                property2.ThrowNonNullablePropertyIsNull();
                                                continue;
                                            }
                                            foreach (var property3 in property2.Value.EnumerateObject())
                                            {
                                                if (property3.NameEquals("mcc"u8))
                                                {
                                                    mcc0 = property3.Value.GetString();
                                                    continue;
                                                }
                                                if (property3.NameEquals("mnc"u8))
                                                {
                                                    mnc0 = property3.Value.GetString();
                                                    continue;
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                            }
                            continue;
                        }
                        if (property0.NameEquals("guti"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("mTmsi"u8))
                                {
                                    mTmsi = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("mmeId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("groupId"u8))
                                        {
                                            groupId = property2.Value.GetInt32();
                                            continue;
                                        }
                                        if (property2.NameEquals("code"u8))
                                        {
                                            code = property2.Value.GetInt32();
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                                if (property1.NameEquals("plmn"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("mcc"u8))
                                        {
                                            mcc1 = property2.Value.GetString();
                                            continue;
                                        }
                                        if (property2.NameEquals("mnc"u8))
                                        {
                                            mnc1 = property2.Value.GetString();
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UEInfo4G(
                ratType,
                lastReadAt,
                serializedAdditionalRawData,
                imsi,
                imei,
                imeisv,
                sessionInfo ?? new ChangeTrackingList<UESessionInfo4G>(),
                perUETnla,
                mmeS1apId,
                enbS1apId,
                lastVisitedTai,
                ueState,
                rrcEstablishmentCause,
                ueUsageSetting,
                lastActivityTime,
                ngeNbId,
                eNbId,
                n3IwfId,
                wagfId,
                tngfId,
                nid,
                bitLength,
                gnbValue,
                mcc,
                mnc,
                locationType,
                tac,
                mcc0,
                mnc0,
                mTmsi,
                groupId,
                code,
                mcc1,
                mnc1);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RatType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ratType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  ratType: ");
                builder.AppendLine($"'{RatType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastReadOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastReadAt: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastReadOn))
                {
                    builder.Append("  lastReadAt: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastReadOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.Append("  info:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Imsi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    imsi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Imsi))
                {
                    builder.Append("    imsi: ");
                    if (Imsi.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Imsi}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Imsi}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Imei), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    imei: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Imei))
                {
                    builder.Append("    imei: ");
                    if (Imei.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Imei}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Imei}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Imeisv), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    imeisv: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Imeisv))
                {
                    builder.Append("    imeisv: ");
                    if (Imeisv.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Imeisv}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Imeisv}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SessionInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sessionInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SessionInfo))
                {
                    if (SessionInfo.Any())
                    {
                        builder.Append("    sessionInfo: ");
                        builder.AppendLine("[");
                        foreach (var item in SessionInfo)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    sessionInfo: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.Append("    connectionInfo:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PerUETnla), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      perUeTnla: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PerUETnla))
                {
                    builder.Append("      perUeTnla: ");
                    if (PerUETnla.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PerUETnla}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PerUETnla}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MmeS1ApId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      mmeS1apId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MmeS1ApId))
                {
                    builder.Append("      mmeS1apId: ");
                    builder.AppendLine($"{MmeS1ApId.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnbS1ApId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      enbS1apId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnbS1ApId))
                {
                    builder.Append("      enbS1apId: ");
                    builder.AppendLine($"{EnbS1ApId.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastVisitedTai), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      lastVisitedTai: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastVisitedTai))
                {
                    builder.Append("      lastVisitedTai: ");
                    if (LastVisitedTai.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastVisitedTai}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastVisitedTai}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UEState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      ueState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UEState))
                {
                    builder.Append("      ueState: ");
                    builder.AppendLine($"'{UEState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RrcEstablishmentCause), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      rrcEstablishmentCause: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RrcEstablishmentCause))
                {
                    builder.Append("      rrcEstablishmentCause: ");
                    builder.AppendLine($"'{RrcEstablishmentCause.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UEUsageSetting), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      ueUsageSetting: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UEUsageSetting))
                {
                    builder.Append("      ueUsageSetting: ");
                    builder.AppendLine($"'{UEUsageSetting.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastActivityOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      lastActivityTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastActivityOn))
                {
                    builder.Append("      lastActivityTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastActivityOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.Append("      globalRanNodeId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NgeNbId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        ngeNbId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NgeNbId))
                {
                    builder.Append("        ngeNbId: ");
                    if (NgeNbId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NgeNbId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NgeNbId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ENbId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        eNbId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ENbId))
                {
                    builder.Append("        eNbId: ");
                    if (ENbId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ENbId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ENbId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(N3IwfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        n3IwfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(N3IwfId))
                {
                    builder.Append("        n3IwfId: ");
                    if (N3IwfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{N3IwfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{N3IwfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WagfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        wagfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WagfId))
                {
                    builder.Append("        wagfId: ");
                    if (WagfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{WagfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{WagfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TngfId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        tngfId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TngfId))
                {
                    builder.Append("        tngfId: ");
                    if (TngfId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TngfId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TngfId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Nid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        nid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Nid))
                {
                    builder.Append("        nid: ");
                    if (Nid.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Nid}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Nid}'");
                    }
                }
            }

            builder.Append("        gNbId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BitLength), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          bitLength: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BitLength))
                {
                    builder.Append("          bitLength: ");
                    builder.AppendLine($"{BitLength.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GNBValue), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          gNBValue: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GNBValue))
                {
                    builder.Append("          gNBValue: ");
                    if (GNBValue.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{GNBValue}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{GNBValue}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.Append("        plmnId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc))
                {
                    builder.Append("          mcc: ");
                    if (MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoConnectionInfoGlobalRanNodeIdPlmnIdMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc))
                {
                    builder.Append("          mnc: ");
                    if (MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoConnectionInfoGlobalRanNodeIdPlmnIdMnc}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.AppendLine("      }");
            builder.Append("      locationInfo:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LocationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        locationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LocationType))
                {
                    builder.Append("        locationType: ");
                    if (LocationType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LocationType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LocationType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tac), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        tac: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Tac))
                {
                    builder.Append("        tac: ");
                    if (Tac.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Tac}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Tac}'");
                    }
                }
            }

            builder.Append("        plmn:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoConnectionInfoLocationInfoPlmnMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoConnectionInfoLocationInfoPlmnMcc))
                {
                    builder.Append("          mcc: ");
                    if (MccInfoConnectionInfoLocationInfoPlmnMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoConnectionInfoLocationInfoPlmnMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoConnectionInfoLocationInfoPlmnMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoConnectionInfoLocationInfoPlmnMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("          mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoConnectionInfoLocationInfoPlmnMnc))
                {
                    builder.Append("          mnc: ");
                    if (MncInfoConnectionInfoLocationInfoPlmnMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoConnectionInfoLocationInfoPlmnMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoConnectionInfoLocationInfoPlmnMnc}'");
                    }
                }
            }

            builder.AppendLine("        }");
            builder.AppendLine("      }");
            builder.AppendLine("    }");
            builder.Append("    guti:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MTmsi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      mTmsi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("      mTmsi: ");
                builder.AppendLine($"{MTmsi}");
            }

            builder.Append("      mmeId:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        groupId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("        groupId: ");
                builder.AppendLine($"{GroupId}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Code), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        code: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("        code: ");
                builder.AppendLine($"{Code}");
            }

            builder.AppendLine("      }");
            builder.Append("      plmn:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MccInfoGutiPlmnMcc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        mcc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MccInfoGutiPlmnMcc))
                {
                    builder.Append("        mcc: ");
                    if (MccInfoGutiPlmnMcc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MccInfoGutiPlmnMcc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MccInfoGutiPlmnMcc}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MncInfoGutiPlmnMnc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("        mnc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MncInfoGutiPlmnMnc))
                {
                    builder.Append("        mnc: ");
                    if (MncInfoGutiPlmnMnc.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MncInfoGutiPlmnMnc}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MncInfoGutiPlmnMnc}'");
                    }
                }
            }

            builder.AppendLine("      }");
            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<UEInfo4G>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo4G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(UEInfo4G)} does not support writing '{options.Format}' format.");
            }
        }

        UEInfo4G IPersistableModel<UEInfo4G>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UEInfo4G>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUEInfo4G(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UEInfo4G)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UEInfo4G>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
