// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The static IP configuration for the SIM to use at the defined network scope.
    /// Serialized Name: SimStaticIpPropertiesStaticIp
    /// </summary>
    internal partial class SimStaticIPPropertiesStaticIP
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SimStaticIPPropertiesStaticIP"/>. </summary>
        public SimStaticIPPropertiesStaticIP()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SimStaticIPPropertiesStaticIP"/>. </summary>
        /// <param name="ipv4Address">
        /// The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        /// Serialized Name: SimStaticIpPropertiesStaticIp.ipv4Address
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SimStaticIPPropertiesStaticIP(string ipv4Address, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPv4Address = ipv4Address;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        /// Serialized Name: SimStaticIpPropertiesStaticIp.ipv4Address
        /// </summary>
        [WirePath("ipv4Address")]
        public string IPv4Address { get; set; }
    }
}
