// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Response for the list routing information API service call.
    /// Serialized Name: RoutingInfoListResult
    /// </summary>
    internal partial class RoutingInfoListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingInfoListResult"/>. </summary>
        internal RoutingInfoListResult()
        {
            Value = new ChangeTrackingList<MobileNetworkRoutingInfoData>();
        }

        /// <summary> Initializes a new instance of <see cref="RoutingInfoListResult"/>. </summary>
        /// <param name="value">
        /// A list of the routing information for the packet core control plane
        /// Serialized Name: RoutingInfoListResult.value
        /// </param>
        /// <param name="nextLink">
        /// The URL to get the next set of results.
        /// Serialized Name: RoutingInfoListResult.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingInfoListResult(IReadOnlyList<MobileNetworkRoutingInfoData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// A list of the routing information for the packet core control plane
        /// Serialized Name: RoutingInfoListResult.value
        /// </summary>
        public IReadOnlyList<MobileNetworkRoutingInfoData> Value { get; }
        /// <summary>
        /// The URL to get the next set of results.
        /// Serialized Name: RoutingInfoListResult.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
