// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// RAT Type
    /// Serialized Name: RatType
    /// </summary>
    public readonly partial struct RatType : IEquatable<RatType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RatType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RatType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FourGValue = "4G";
        private const string FiveGValue = "5G";

        /// <summary>
        /// 4G
        /// Serialized Name: RatType.4G
        /// </summary>
        public static RatType FourG { get; } = new RatType(FourGValue);
        /// <summary>
        /// 5G
        /// Serialized Name: RatType.5G
        /// </summary>
        public static RatType FiveG { get; } = new RatType(FiveGValue);
        /// <summary> Determines if two <see cref="RatType"/> values are the same. </summary>
        public static bool operator ==(RatType left, RatType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RatType"/> values are not the same. </summary>
        public static bool operator !=(RatType left, RatType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RatType"/>. </summary>
        public static implicit operator RatType(string value) => new RatType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RatType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RatType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
