// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Configuration relating to SUPI concealment.
    /// Serialized Name: PublicLandMobileNetworkHomeNetworkPublicKeys
    /// </summary>
    public partial class PublicLandMobileNetworkHomeNetworkPublicKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PublicLandMobileNetworkHomeNetworkPublicKeys"/>. </summary>
        public PublicLandMobileNetworkHomeNetworkPublicKeys()
        {
            ProfileA = new ChangeTrackingList<HomeNetworkPublicKey>();
            ProfileB = new ChangeTrackingList<HomeNetworkPublicKey>();
        }

        /// <summary> Initializes a new instance of <see cref="PublicLandMobileNetworkHomeNetworkPublicKeys"/>. </summary>
        /// <param name="profileA">
        /// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile A Protection Scheme.
        /// Serialized Name: PublicLandMobileNetworkHomeNetworkPublicKeys.profileA
        /// </param>
        /// <param name="profileB">
        /// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile B Protection Scheme.
        /// Serialized Name: PublicLandMobileNetworkHomeNetworkPublicKeys.profileB
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PublicLandMobileNetworkHomeNetworkPublicKeys(IList<HomeNetworkPublicKey> profileA, IList<HomeNetworkPublicKey> profileB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProfileA = profileA;
            ProfileB = profileB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile A Protection Scheme.
        /// Serialized Name: PublicLandMobileNetworkHomeNetworkPublicKeys.profileA
        /// </summary>
        [WirePath("profileA")]
        public IList<HomeNetworkPublicKey> ProfileA { get; }
        /// <summary>
        /// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile B Protection Scheme.
        /// Serialized Name: PublicLandMobileNetworkHomeNetworkPublicKeys.profileB
        /// </summary>
        [WirePath("profileB")]
        public IList<HomeNetworkPublicKey> ProfileB { get; }
    }
}
