// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Configuration relating to a particular PLMN
    /// Serialized Name: PublicLandMobileNetwork
    /// </summary>
    public partial class PublicLandMobileNetwork : MobileNetworkPlmnId
    {
        /// <summary> Initializes a new instance of <see cref="PublicLandMobileNetwork"/>. </summary>
        /// <param name="mcc">
        /// Mobile country code (MCC).
        /// Serialized Name: PlmnId.mcc
        /// </param>
        /// <param name="mnc">
        /// Mobile network code (MNC).
        /// Serialized Name: PlmnId.mnc
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="mcc"/> or <paramref name="mnc"/> is null. </exception>
        public PublicLandMobileNetwork(string mcc, string mnc) : base(mcc, mnc)
        {
            Argument.AssertNotNull(mcc, nameof(mcc));
            Argument.AssertNotNull(mnc, nameof(mnc));
        }

        /// <summary> Initializes a new instance of <see cref="PublicLandMobileNetwork"/>. </summary>
        /// <param name="mcc">
        /// Mobile country code (MCC).
        /// Serialized Name: PlmnId.mcc
        /// </param>
        /// <param name="mnc">
        /// Mobile network code (MNC).
        /// Serialized Name: PlmnId.mnc
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="homeNetworkPublicKeys">
        /// Configuration relating to SUPI concealment.
        /// Serialized Name: PublicLandMobileNetwork.homeNetworkPublicKeys
        /// </param>
        internal PublicLandMobileNetwork(string mcc, string mnc, IDictionary<string, BinaryData> serializedAdditionalRawData, PublicLandMobileNetworkHomeNetworkPublicKeys homeNetworkPublicKeys) : base(mcc, mnc, serializedAdditionalRawData)
        {
            HomeNetworkPublicKeys = homeNetworkPublicKeys;
        }

        /// <summary> Initializes a new instance of <see cref="PublicLandMobileNetwork"/> for deserialization. </summary>
        internal PublicLandMobileNetwork()
        {
        }

        /// <summary>
        /// Configuration relating to SUPI concealment.
        /// Serialized Name: PublicLandMobileNetwork.homeNetworkPublicKeys
        /// </summary>
        [WirePath("homeNetworkPublicKeys")]
        public PublicLandMobileNetworkHomeNetworkPublicKeys HomeNetworkPublicKeys { get; set; }
    }
}
