// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Packet Data Network Type
    /// Serialized Name: PdnType
    /// </summary>
    public readonly partial struct PdnType : IEquatable<PdnType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PdnType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PdnType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPV4Value = "IPV4";

        /// <summary>
        /// IPV4
        /// Serialized Name: PdnType.IPV4
        /// </summary>
        public static PdnType IPV4 { get; } = new PdnType(IPV4Value);
        /// <summary> Determines if two <see cref="PdnType"/> values are the same. </summary>
        public static bool operator ==(PdnType left, PdnType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PdnType"/> values are not the same. </summary>
        public static bool operator !=(PdnType left, PdnType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PdnType"/>. </summary>
        public static implicit operator PdnType(string value) => new PdnType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PdnType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PdnType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
