// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class PccRuleQosPolicy : IUtf8JsonSerializable, IJsonModel<PccRuleQosPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PccRuleQosPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PccRuleQosPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleQosPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PccRuleQosPolicy)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(GuaranteedBitRate))
            {
                writer.WritePropertyName("guaranteedBitRate"u8);
                writer.WriteObjectValue(GuaranteedBitRate, options);
            }
        }

        PccRuleQosPolicy IJsonModel<PccRuleQosPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleQosPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PccRuleQosPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePccRuleQosPolicy(document.RootElement, options);
        }

        internal static PccRuleQosPolicy DeserializePccRuleQosPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Ambr guaranteedBitRate = default;
            int? _5qi = default;
            int? allocationAndRetentionPriorityLevel = default;
            MobileNetworkPreemptionCapability? preemptionCapability = default;
            MobileNetworkPreemptionVulnerability? preemptionVulnerability = default;
            Ambr maximumBitRate = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("guaranteedBitRate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    guaranteedBitRate = Ambr.DeserializeAmbr(property.Value, options);
                    continue;
                }
                if (property.NameEquals("5qi"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    _5qi = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allocationAndRetentionPriorityLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationAndRetentionPriorityLevel = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("preemptionCapability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preemptionCapability = new MobileNetworkPreemptionCapability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("preemptionVulnerability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preemptionVulnerability = new MobileNetworkPreemptionVulnerability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maximumBitRate"u8))
                {
                    maximumBitRate = Ambr.DeserializeAmbr(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PccRuleQosPolicy(
                _5qi,
                allocationAndRetentionPriorityLevel,
                preemptionCapability,
                preemptionVulnerability,
                maximumBitRate,
                serializedAdditionalRawData,
                guaranteedBitRate);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GuaranteedBitRate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  guaranteedBitRate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GuaranteedBitRate))
                {
                    builder.Append("  guaranteedBitRate: ");
                    BicepSerializationHelpers.AppendChildObject(builder, GuaranteedBitRate, options, 2, false, "  guaranteedBitRate: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FiveQi), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  5qi: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FiveQi))
                {
                    builder.Append("  5qi: ");
                    builder.AppendLine($"{FiveQi.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllocationAndRetentionPriorityLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allocationAndRetentionPriorityLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AllocationAndRetentionPriorityLevel))
                {
                    builder.Append("  allocationAndRetentionPriorityLevel: ");
                    builder.AppendLine($"{AllocationAndRetentionPriorityLevel.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PreemptionCapability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  preemptionCapability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PreemptionCapability))
                {
                    builder.Append("  preemptionCapability: ");
                    builder.AppendLine($"'{PreemptionCapability.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PreemptionVulnerability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  preemptionVulnerability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PreemptionVulnerability))
                {
                    builder.Append("  preemptionVulnerability: ");
                    builder.AppendLine($"'{PreemptionVulnerability.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaximumBitRate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maximumBitRate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaximumBitRate))
                {
                    builder.Append("  maximumBitRate: ");
                    BicepSerializationHelpers.AppendChildObject(builder, MaximumBitRate, options, 2, false, "  maximumBitRate: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PccRuleQosPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleQosPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PccRuleQosPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        PccRuleQosPolicy IPersistableModel<PccRuleQosPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleQosPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePccRuleQosPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PccRuleQosPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PccRuleQosPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
