// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class PccRuleConfiguration : IUtf8JsonSerializable, IJsonModel<PccRuleConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PccRuleConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PccRuleConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PccRuleConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("ruleName"u8);
            writer.WriteStringValue(RuleName);
            writer.WritePropertyName("rulePrecedence"u8);
            writer.WriteNumberValue(RulePrecedence);
            if (Optional.IsDefined(RuleQosPolicy))
            {
                writer.WritePropertyName("ruleQosPolicy"u8);
                writer.WriteObjectValue(RuleQosPolicy, options);
            }
            if (Optional.IsDefined(TrafficControl))
            {
                writer.WritePropertyName("trafficControl"u8);
                writer.WriteStringValue(TrafficControl.Value.ToString());
            }
            writer.WritePropertyName("serviceDataFlowTemplates"u8);
            writer.WriteStartArray();
            foreach (var item in ServiceDataFlowTemplates)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PccRuleConfiguration IJsonModel<PccRuleConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PccRuleConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePccRuleConfiguration(document.RootElement, options);
        }

        internal static PccRuleConfiguration DeserializePccRuleConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string ruleName = default;
            int rulePrecedence = default;
            PccRuleQosPolicy ruleQosPolicy = default;
            MobileNetworkTrafficControlPermission? trafficControl = default;
            IList<MobileNetworkServiceDataFlowTemplate> serviceDataFlowTemplates = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ruleName"u8))
                {
                    ruleName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rulePrecedence"u8))
                {
                    rulePrecedence = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ruleQosPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ruleQosPolicy = PccRuleQosPolicy.DeserializePccRuleQosPolicy(property.Value, options);
                    continue;
                }
                if (property.NameEquals("trafficControl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    trafficControl = new MobileNetworkTrafficControlPermission(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("serviceDataFlowTemplates"u8))
                {
                    List<MobileNetworkServiceDataFlowTemplate> array = new List<MobileNetworkServiceDataFlowTemplate>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MobileNetworkServiceDataFlowTemplate.DeserializeMobileNetworkServiceDataFlowTemplate(item, options));
                    }
                    serviceDataFlowTemplates = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PccRuleConfiguration(
                ruleName,
                rulePrecedence,
                ruleQosPolicy,
                trafficControl,
                serviceDataFlowTemplates,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RuleName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ruleName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RuleName))
                {
                    builder.Append("  ruleName: ");
                    if (RuleName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RuleName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RuleName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RulePrecedence), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rulePrecedence: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  rulePrecedence: ");
                builder.AppendLine($"{RulePrecedence}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RuleQosPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ruleQosPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RuleQosPolicy))
                {
                    builder.Append("  ruleQosPolicy: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RuleQosPolicy, options, 2, false, "  ruleQosPolicy: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TrafficControl), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  trafficControl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TrafficControl))
                {
                    builder.Append("  trafficControl: ");
                    builder.AppendLine($"'{TrafficControl.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceDataFlowTemplates), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceDataFlowTemplates: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ServiceDataFlowTemplates))
                {
                    if (ServiceDataFlowTemplates.Any())
                    {
                        builder.Append("  serviceDataFlowTemplates: ");
                        builder.AppendLine("[");
                        foreach (var item in ServiceDataFlowTemplates)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  serviceDataFlowTemplates: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PccRuleConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PccRuleConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        PccRuleConfiguration IPersistableModel<PccRuleConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PccRuleConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePccRuleConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PccRuleConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PccRuleConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
