// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Signaling configuration for the packet core.
    /// Serialized Name: SignalingConfiguration
    /// </summary>
    public partial class PacketCoreSignalingConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PacketCoreSignalingConfiguration"/>. </summary>
        public PacketCoreSignalingConfiguration()
        {
            NasEncryption = new ChangeTrackingList<MobileNetworkNasEncryptionType>();
        }

        /// <summary> Initializes a new instance of <see cref="PacketCoreSignalingConfiguration"/>. </summary>
        /// <param name="nasReroute">
        /// Configuration enabling 4G NAS reroute.
        /// Serialized Name: SignalingConfiguration.nasReroute
        /// </param>
        /// <param name="nasEncryption">
        /// An ordered list of NAS encryption algorithms, used to encrypt control plane traffic between the UE and packet core, in order from most to least preferred. If not specified, the packet core will use a built-in default ordering.
        /// Serialized Name: SignalingConfiguration.nasEncryption
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PacketCoreSignalingConfiguration(NASRerouteConfiguration nasReroute, IList<MobileNetworkNasEncryptionType> nasEncryption, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NasReroute = nasReroute;
            NasEncryption = nasEncryption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Configuration enabling 4G NAS reroute.
        /// Serialized Name: SignalingConfiguration.nasReroute
        /// </summary>
        internal NASRerouteConfiguration NasReroute { get; set; }
        /// <summary>
        /// The macro network's MME group ID. This is where unknown UEs are sent to via NAS reroute.
        /// Serialized Name: NASRerouteConfiguration.macroMmeGroupId
        /// </summary>
        [WirePath("nasReroute.macroMmeGroupId")]
        public int? NasRerouteMacroMmeGroupId
        {
            get => NasReroute is null ? default(int?) : NasReroute.MacroMmeGroupId;
            set
            {
                NasReroute = value.HasValue ? new NASRerouteConfiguration(value.Value) : null;
            }
        }

        /// <summary>
        /// An ordered list of NAS encryption algorithms, used to encrypt control plane traffic between the UE and packet core, in order from most to least preferred. If not specified, the packet core will use a built-in default ordering.
        /// Serialized Name: SignalingConfiguration.nasEncryption
        /// </summary>
        [WirePath("nasEncryption")]
        public IList<MobileNetworkNasEncryptionType> NasEncryption { get; }
    }
}
