// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Packet core control plane collect diagnostics package options
    /// Serialized Name: PacketCoreControlPlaneCollectDiagnosticsPackage
    /// </summary>
    public partial class PacketCoreControlPlaneCollectDiagnosticsPackage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PacketCoreControlPlaneCollectDiagnosticsPackage"/>. </summary>
        /// <param name="storageAccountBlobUri">
        /// The Storage Account Blob URL to upload the diagnostics package to.
        /// Serialized Name: PacketCoreControlPlaneCollectDiagnosticsPackage.storageAccountBlobUrl
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageAccountBlobUri"/> is null. </exception>
        public PacketCoreControlPlaneCollectDiagnosticsPackage(Uri storageAccountBlobUri)
        {
            Argument.AssertNotNull(storageAccountBlobUri, nameof(storageAccountBlobUri));

            StorageAccountBlobUri = storageAccountBlobUri;
        }

        /// <summary> Initializes a new instance of <see cref="PacketCoreControlPlaneCollectDiagnosticsPackage"/>. </summary>
        /// <param name="storageAccountBlobUri">
        /// The Storage Account Blob URL to upload the diagnostics package to.
        /// Serialized Name: PacketCoreControlPlaneCollectDiagnosticsPackage.storageAccountBlobUrl
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PacketCoreControlPlaneCollectDiagnosticsPackage(Uri storageAccountBlobUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccountBlobUri = storageAccountBlobUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PacketCoreControlPlaneCollectDiagnosticsPackage"/> for deserialization. </summary>
        internal PacketCoreControlPlaneCollectDiagnosticsPackage()
        {
        }

        /// <summary>
        /// The Storage Account Blob URL to upload the diagnostics package to.
        /// Serialized Name: PacketCoreControlPlaneCollectDiagnosticsPackage.storageAccountBlobUrl
        /// </summary>
        [WirePath("storageAccountBlobUrl")]
        public Uri StorageAccountBlobUri { get; }
    }
}
