// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    public partial class PacketCoreControlPlaneCollectDiagnosticsPackage : IUtf8JsonSerializable, IJsonModel<PacketCoreControlPlaneCollectDiagnosticsPackage>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PacketCoreControlPlaneCollectDiagnosticsPackage>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PacketCoreControlPlaneCollectDiagnosticsPackage>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCoreControlPlaneCollectDiagnosticsPackage)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("storageAccountBlobUrl"u8);
            writer.WriteStringValue(StorageAccountBlobUri.AbsoluteUri);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PacketCoreControlPlaneCollectDiagnosticsPackage IJsonModel<PacketCoreControlPlaneCollectDiagnosticsPackage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCoreControlPlaneCollectDiagnosticsPackage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePacketCoreControlPlaneCollectDiagnosticsPackage(document.RootElement, options);
        }

        internal static PacketCoreControlPlaneCollectDiagnosticsPackage DeserializePacketCoreControlPlaneCollectDiagnosticsPackage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri storageAccountBlobUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("storageAccountBlobUrl"u8))
                {
                    storageAccountBlobUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PacketCoreControlPlaneCollectDiagnosticsPackage(storageAccountBlobUrl, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PacketCoreControlPlaneCollectDiagnosticsPackage)} does not support writing '{options.Format}' format.");
            }
        }

        PacketCoreControlPlaneCollectDiagnosticsPackage IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePacketCoreControlPlaneCollectDiagnosticsPackage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PacketCoreControlPlaneCollectDiagnosticsPackage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PacketCoreControlPlaneCollectDiagnosticsPackage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
