// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Configuration enabling NAS reroute.
    /// Serialized Name: NASRerouteConfiguration
    /// </summary>
    internal partial class NASRerouteConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NASRerouteConfiguration"/>. </summary>
        /// <param name="macroMmeGroupId">
        /// The macro network's MME group ID. This is where unknown UEs are sent to via NAS reroute.
        /// Serialized Name: NASRerouteConfiguration.macroMmeGroupId
        /// </param>
        public NASRerouteConfiguration(int macroMmeGroupId)
        {
            MacroMmeGroupId = macroMmeGroupId;
        }

        /// <summary> Initializes a new instance of <see cref="NASRerouteConfiguration"/>. </summary>
        /// <param name="macroMmeGroupId">
        /// The macro network's MME group ID. This is where unknown UEs are sent to via NAS reroute.
        /// Serialized Name: NASRerouteConfiguration.macroMmeGroupId
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NASRerouteConfiguration(int macroMmeGroupId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MacroMmeGroupId = macroMmeGroupId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NASRerouteConfiguration"/> for deserialization. </summary>
        internal NASRerouteConfiguration()
        {
        }

        /// <summary>
        /// The macro network's MME group ID. This is where unknown UEs are sent to via NAS reroute.
        /// Serialized Name: NASRerouteConfiguration.macroMmeGroupId
        /// </summary>
        [WirePath("macroMmeGroupId")]
        public int MacroMmeGroupId { get; set; }
    }
}
