// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The state of the SIM resource.
    /// Serialized Name: SimState
    /// </summary>
    public readonly partial struct MobileNetworkSimState : IEquatable<MobileNetworkSimState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkSimState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkSimState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";
        private const string InvalidValue = "Invalid";

        /// <summary>
        /// The SIM is disabled because not all configuration required for enabling is present.
        /// Serialized Name: SimState.Disabled
        /// </summary>
        public static MobileNetworkSimState Disabled { get; } = new MobileNetworkSimState(DisabledValue);
        /// <summary>
        /// The SIM is enabled.
        /// Serialized Name: SimState.Enabled
        /// </summary>
        public static MobileNetworkSimState Enabled { get; } = new MobileNetworkSimState(EnabledValue);
        /// <summary>
        /// The SIM cannot be enabled because some of the associated configuration is invalid.
        /// Serialized Name: SimState.Invalid
        /// </summary>
        public static MobileNetworkSimState Invalid { get; } = new MobileNetworkSimState(InvalidValue);
        /// <summary> Determines if two <see cref="MobileNetworkSimState"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkSimState left, MobileNetworkSimState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkSimState"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkSimState left, MobileNetworkSimState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkSimState"/>. </summary>
        public static implicit operator MobileNetworkSimState(string value) => new MobileNetworkSimState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkSimState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkSimState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
