// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Identity and Tags object for patch operations.
    /// Serialized Name: IdentityAndTagsObject
    /// </summary>
    public partial class MobileNetworkResourcePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkResourcePatch"/>. </summary>
        public MobileNetworkResourcePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkResourcePatch"/>. </summary>
        /// <param name="userAssignedIdentity">
        /// The managed service identity associated with this resource.
        /// Serialized Name: IdentityAndTagsObject.identity
        /// </param>
        /// <param name="tags">
        /// Resource tags.
        /// Serialized Name: IdentityAndTagsObject.tags
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkResourcePatch(MobileNetworkManagedServiceIdentity userAssignedIdentity, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserAssignedIdentity = userAssignedIdentity;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The managed service identity associated with this resource.
        /// Serialized Name: IdentityAndTagsObject.identity
        /// </summary>
        [WirePath("identity")]
        public MobileNetworkManagedServiceIdentity UserAssignedIdentity { get; set; }
        /// <summary>
        /// Resource tags.
        /// Serialized Name: IdentityAndTagsObject.tags
        /// </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
    }
}
