// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Indicates whether this is the recommended version to use for new packet core control plane deployments.
    /// Serialized Name: RecommendedVersion
    /// </summary>
    public readonly partial struct MobileNetworkRecommendedVersion : IEquatable<MobileNetworkRecommendedVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkRecommendedVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkRecommendedVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RecommendedValue = "Recommended";
        private const string NotRecommendedValue = "NotRecommended";

        /// <summary>
        /// This is the recommended version to use for new packet core control plane deployments.
        /// Serialized Name: RecommendedVersion.Recommended
        /// </summary>
        public static MobileNetworkRecommendedVersion Recommended { get; } = new MobileNetworkRecommendedVersion(RecommendedValue);
        /// <summary>
        /// This is not the recommended version to use for new packet core control plane deployments.
        /// Serialized Name: RecommendedVersion.NotRecommended
        /// </summary>
        public static MobileNetworkRecommendedVersion NotRecommended { get; } = new MobileNetworkRecommendedVersion(NotRecommendedValue);
        /// <summary> Determines if two <see cref="MobileNetworkRecommendedVersion"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkRecommendedVersion left, MobileNetworkRecommendedVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkRecommendedVersion"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkRecommendedVersion left, MobileNetworkRecommendedVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkRecommendedVersion"/>. </summary>
        public static implicit operator MobileNetworkRecommendedVersion(string value) => new MobileNetworkRecommendedVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkRecommendedVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkRecommendedVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
