// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// QoS policy
    /// Serialized Name: QosPolicy
    /// </summary>
    public partial class MobileNetworkQosPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkQosPolicy"/>. </summary>
        /// <param name="maximumBitRate">
        /// The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
        /// Serialized Name: QosPolicy.maximumBitRate
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="maximumBitRate"/> is null. </exception>
        public MobileNetworkQosPolicy(Ambr maximumBitRate)
        {
            Argument.AssertNotNull(maximumBitRate, nameof(maximumBitRate));

            MaximumBitRate = maximumBitRate;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkQosPolicy"/>. </summary>
        /// <param name="fiveQi">
        /// 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
        /// Serialized Name: QosPolicy.5qi
        /// </param>
        /// <param name="allocationAndRetentionPriorityLevel">
        /// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.allocationAndRetentionPriorityLevel
        /// </param>
        /// <param name="preemptionCapability">
        /// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.preemptionCapability
        /// </param>
        /// <param name="preemptionVulnerability">
        /// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.preemptionVulnerability
        /// </param>
        /// <param name="maximumBitRate">
        /// The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
        /// Serialized Name: QosPolicy.maximumBitRate
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkQosPolicy(int? fiveQi, int? allocationAndRetentionPriorityLevel, MobileNetworkPreemptionCapability? preemptionCapability, MobileNetworkPreemptionVulnerability? preemptionVulnerability, Ambr maximumBitRate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FiveQi = fiveQi;
            AllocationAndRetentionPriorityLevel = allocationAndRetentionPriorityLevel;
            PreemptionCapability = preemptionCapability;
            PreemptionVulnerability = preemptionVulnerability;
            MaximumBitRate = maximumBitRate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkQosPolicy"/> for deserialization. </summary>
        internal MobileNetworkQosPolicy()
        {
        }

        /// <summary>
        /// 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
        /// Serialized Name: QosPolicy.5qi
        /// </summary>
        [WirePath("5qi")]
        public int? FiveQi { get; set; }
        /// <summary>
        /// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.allocationAndRetentionPriorityLevel
        /// </summary>
        [WirePath("allocationAndRetentionPriorityLevel")]
        public int? AllocationAndRetentionPriorityLevel { get; set; }
        /// <summary>
        /// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.preemptionCapability
        /// </summary>
        [WirePath("preemptionCapability")]
        public MobileNetworkPreemptionCapability? PreemptionCapability { get; set; }
        /// <summary>
        /// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        /// Serialized Name: QosPolicy.preemptionVulnerability
        /// </summary>
        [WirePath("preemptionVulnerability")]
        public MobileNetworkPreemptionVulnerability? PreemptionVulnerability { get; set; }
        /// <summary>
        /// The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
        /// Serialized Name: QosPolicy.maximumBitRate
        /// </summary>
        [WirePath("maximumBitRate")]
        public Ambr MaximumBitRate { get; set; }
    }
}
