// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Preemption vulnerability.
    /// Serialized Name: PreemptionVulnerability
    /// </summary>
    public readonly partial struct MobileNetworkPreemptionVulnerability : IEquatable<MobileNetworkPreemptionVulnerability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPreemptionVulnerability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkPreemptionVulnerability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotPreemptableValue = "NotPreemptable";
        private const string PreemptableValue = "Preemptable";

        /// <summary>
        /// Cannot be preempted
        /// Serialized Name: PreemptionVulnerability.NotPreemptable
        /// </summary>
        public static MobileNetworkPreemptionVulnerability NotPreemptable { get; } = new MobileNetworkPreemptionVulnerability(NotPreemptableValue);
        /// <summary>
        /// May be preempted
        /// Serialized Name: PreemptionVulnerability.Preemptable
        /// </summary>
        public static MobileNetworkPreemptionVulnerability Preemptable { get; } = new MobileNetworkPreemptionVulnerability(PreemptableValue);
        /// <summary> Determines if two <see cref="MobileNetworkPreemptionVulnerability"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkPreemptionVulnerability left, MobileNetworkPreemptionVulnerability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkPreemptionVulnerability"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkPreemptionVulnerability left, MobileNetworkPreemptionVulnerability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkPreemptionVulnerability"/>. </summary>
        public static implicit operator MobileNetworkPreemptionVulnerability(string value) => new MobileNetworkPreemptionVulnerability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkPreemptionVulnerability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkPreemptionVulnerability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
