// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Preemption capability.
    /// Serialized Name: PreemptionCapability
    /// </summary>
    public readonly partial struct MobileNetworkPreemptionCapability : IEquatable<MobileNetworkPreemptionCapability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPreemptionCapability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkPreemptionCapability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotPreemptValue = "NotPreempt";
        private const string MayPreemptValue = "MayPreempt";

        /// <summary>
        /// Cannot preempt
        /// Serialized Name: PreemptionCapability.NotPreempt
        /// </summary>
        public static MobileNetworkPreemptionCapability NotPreempt { get; } = new MobileNetworkPreemptionCapability(NotPreemptValue);
        /// <summary>
        /// May preempt
        /// Serialized Name: PreemptionCapability.MayPreempt
        /// </summary>
        public static MobileNetworkPreemptionCapability MayPreempt { get; } = new MobileNetworkPreemptionCapability(MayPreemptValue);
        /// <summary> Determines if two <see cref="MobileNetworkPreemptionCapability"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkPreemptionCapability left, MobileNetworkPreemptionCapability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkPreemptionCapability"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkPreemptionCapability left, MobileNetworkPreemptionCapability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkPreemptionCapability"/>. </summary>
        public static implicit operator MobileNetworkPreemptionCapability(string value) => new MobileNetworkPreemptionCapability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkPreemptionCapability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkPreemptionCapability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
