// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
    /// Serialized Name: PortReuseHoldTimes
    /// </summary>
    public partial class MobileNetworkPortReuseHoldTimes
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPortReuseHoldTimes"/>. </summary>
        public MobileNetworkPortReuseHoldTimes()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPortReuseHoldTimes"/>. </summary>
        /// <param name="tcp">
        /// Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        /// Serialized Name: PortReuseHoldTimes.tcp
        /// </param>
        /// <param name="udp">
        /// Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        /// Serialized Name: PortReuseHoldTimes.udp
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkPortReuseHoldTimes(int? tcp, int? udp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tcp = tcp;
            Udp = udp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        /// Serialized Name: PortReuseHoldTimes.tcp
        /// </summary>
        [WirePath("tcp")]
        public int? Tcp { get; set; }
        /// <summary>
        /// Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        /// Serialized Name: PortReuseHoldTimes.udp
        /// </summary>
        [WirePath("udp")]
        public int? Udp { get; set; }
    }
}
