// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Range of port numbers to use as translated ports on each translated address.
    /// If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
    /// (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
    /// Serialized Name: PortRange
    /// </summary>
    public partial class MobileNetworkPortRange
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPortRange"/>. </summary>
        public MobileNetworkPortRange()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPortRange"/>. </summary>
        /// <param name="minPort">
        /// The minimum port number
        /// Serialized Name: PortRange.minPort
        /// </param>
        /// <param name="maxPort">
        /// The maximum port number
        /// Serialized Name: PortRange.maxPort
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkPortRange(int? minPort, int? maxPort, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MinPort = minPort;
            MaxPort = maxPort;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The minimum port number
        /// Serialized Name: PortRange.minPort
        /// </summary>
        [WirePath("minPort")]
        public int? MinPort { get; set; }
        /// <summary>
        /// The maximum port number
        /// Serialized Name: PortRange.maxPort
        /// </summary>
        [WirePath("maxPort")]
        public int? MaxPort { get; set; }
    }
}
