// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Public land mobile network (PLMN) ID. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
    /// Serialized Name: PlmnId
    /// </summary>
    public partial class MobileNetworkPlmnId
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlmnId"/>. </summary>
        /// <param name="mcc">
        /// Mobile country code (MCC).
        /// Serialized Name: PlmnId.mcc
        /// </param>
        /// <param name="mnc">
        /// Mobile network code (MNC).
        /// Serialized Name: PlmnId.mnc
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="mcc"/> or <paramref name="mnc"/> is null. </exception>
        public MobileNetworkPlmnId(string mcc, string mnc)
        {
            Argument.AssertNotNull(mcc, nameof(mcc));
            Argument.AssertNotNull(mnc, nameof(mnc));

            Mcc = mcc;
            Mnc = mnc;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlmnId"/>. </summary>
        /// <param name="mcc">
        /// Mobile country code (MCC).
        /// Serialized Name: PlmnId.mcc
        /// </param>
        /// <param name="mnc">
        /// Mobile network code (MNC).
        /// Serialized Name: PlmnId.mnc
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkPlmnId(string mcc, string mnc, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mcc = mcc;
            Mnc = mnc;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlmnId"/> for deserialization. </summary>
        internal MobileNetworkPlmnId()
        {
        }

        /// <summary>
        /// Mobile country code (MCC).
        /// Serialized Name: PlmnId.mcc
        /// </summary>
        [WirePath("mcc")]
        public string Mcc { get; set; }
        /// <summary>
        /// Mobile network code (MNC).
        /// Serialized Name: PlmnId.mnc
        /// </summary>
        [WirePath("mnc")]
        public string Mnc { get; set; }
    }
}
