// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The platform type where packet core is deployed. The contents of this enum can change.
    /// Serialized Name: PlatformType
    /// </summary>
    public readonly partial struct MobileNetworkPlatformType : IEquatable<MobileNetworkPlatformType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlatformType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkPlatformType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSHCIValue = "AKS-HCI";
        private const string ThreePAzureStackHCIValue = "3P-AZURE-STACK-HCI";

        /// <summary>
        /// If this option is chosen, you must set one of "azureStackEdgeDevice", "connectedCluster" or "customLocation". If multiple are set, they must be consistent with each other.
        /// Serialized Name: PlatformType.AKS-HCI
        /// </summary>
        public static MobileNetworkPlatformType AKSHCI { get; } = new MobileNetworkPlatformType(AKSHCIValue);
        /// <summary>
        /// If this option is chosen, you must set one of "azureStackHciCluster", "connectedCluster" or "customLocation". If multiple are set, they must be consistent with each other.
        /// Serialized Name: PlatformType.3P-AZURE-STACK-HCI
        /// </summary>
        public static MobileNetworkPlatformType ThreePAzureStackHCI { get; } = new MobileNetworkPlatformType(ThreePAzureStackHCIValue);
        /// <summary> Determines if two <see cref="MobileNetworkPlatformType"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkPlatformType left, MobileNetworkPlatformType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkPlatformType"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkPlatformType left, MobileNetworkPlatformType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkPlatformType"/>. </summary>
        public static implicit operator MobileNetworkPlatformType(string value) => new MobileNetworkPlatformType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkPlatformType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkPlatformType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
