// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Platform specific packet core control plane version properties.
    /// Serialized Name: Platform
    /// </summary>
    public partial class MobileNetworkPlatform
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlatform"/>. </summary>
        public MobileNetworkPlatform()
        {
            HaUpgradesAvailable = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkPlatform"/>. </summary>
        /// <param name="platformType">
        /// The platform type where this version can be deployed.
        /// Serialized Name: Platform.platformType
        /// </param>
        /// <param name="versionState">
        /// The state of this packet core control plane version on this platform.
        /// Serialized Name: Platform.versionState
        /// </param>
        /// <param name="minimumPlatformSoftwareVersion">
        /// The minimum software version of the platform where this packet core version can be deployed.
        /// Serialized Name: Platform.minimumPlatformSoftwareVersion
        /// </param>
        /// <param name="maximumPlatformSoftwareVersion">
        /// The maximum software version of the platform where this packet core version can be deployed.
        /// Serialized Name: Platform.maximumPlatformSoftwareVersion
        /// </param>
        /// <param name="recommendedVersion">
        /// Indicates whether this is the recommended version for this platform.
        /// Serialized Name: Platform.recommendedVersion
        /// </param>
        /// <param name="obsoleteVersion">
        /// Indicates whether this version is obsoleted for this platform.
        /// Serialized Name: Platform.obsoleteVersion
        /// </param>
        /// <param name="haUpgradesAvailable">
        /// The list of versions to which a high availability upgrade from this version is supported.
        /// Serialized Name: Platform.haUpgradesAvailable
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkPlatform(MobileNetworkPlatformType? platformType, MobileNetworkVersionState? versionState, string minimumPlatformSoftwareVersion, string maximumPlatformSoftwareVersion, MobileNetworkRecommendedVersion? recommendedVersion, MobileNetworkObsoleteVersion? obsoleteVersion, IList<string> haUpgradesAvailable, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PlatformType = platformType;
            VersionState = versionState;
            MinimumPlatformSoftwareVersion = minimumPlatformSoftwareVersion;
            MaximumPlatformSoftwareVersion = maximumPlatformSoftwareVersion;
            RecommendedVersion = recommendedVersion;
            ObsoleteVersion = obsoleteVersion;
            HaUpgradesAvailable = haUpgradesAvailable;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The platform type where this version can be deployed.
        /// Serialized Name: Platform.platformType
        /// </summary>
        [WirePath("platformType")]
        public MobileNetworkPlatformType? PlatformType { get; set; }
        /// <summary>
        /// The state of this packet core control plane version on this platform.
        /// Serialized Name: Platform.versionState
        /// </summary>
        [WirePath("versionState")]
        public MobileNetworkVersionState? VersionState { get; set; }
        /// <summary>
        /// The minimum software version of the platform where this packet core version can be deployed.
        /// Serialized Name: Platform.minimumPlatformSoftwareVersion
        /// </summary>
        [WirePath("minimumPlatformSoftwareVersion")]
        public string MinimumPlatformSoftwareVersion { get; set; }
        /// <summary>
        /// The maximum software version of the platform where this packet core version can be deployed.
        /// Serialized Name: Platform.maximumPlatformSoftwareVersion
        /// </summary>
        [WirePath("maximumPlatformSoftwareVersion")]
        public string MaximumPlatformSoftwareVersion { get; set; }
        /// <summary>
        /// Indicates whether this is the recommended version for this platform.
        /// Serialized Name: Platform.recommendedVersion
        /// </summary>
        [WirePath("recommendedVersion")]
        public MobileNetworkRecommendedVersion? RecommendedVersion { get; set; }
        /// <summary>
        /// Indicates whether this version is obsoleted for this platform.
        /// Serialized Name: Platform.obsoleteVersion
        /// </summary>
        [WirePath("obsoleteVersion")]
        public MobileNetworkObsoleteVersion? ObsoleteVersion { get; set; }
        /// <summary>
        /// The list of versions to which a high availability upgrade from this version is supported.
        /// Serialized Name: Platform.haUpgradesAvailable
        /// </summary>
        [WirePath("haUpgradesAvailable")]
        public IList<string> HaUpgradesAvailable { get; }
    }
}
