// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Indicates whether this version is obsolete.
    /// Serialized Name: ObsoleteVersion
    /// </summary>
    public readonly partial struct MobileNetworkObsoleteVersion : IEquatable<MobileNetworkObsoleteVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkObsoleteVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkObsoleteVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ObsoleteValue = "Obsolete";
        private const string NotObsoleteValue = "NotObsolete";

        /// <summary>
        /// This version is obsolete for use in new packet core control plane deployments.
        /// Serialized Name: ObsoleteVersion.Obsolete
        /// </summary>
        public static MobileNetworkObsoleteVersion Obsolete { get; } = new MobileNetworkObsoleteVersion(ObsoleteValue);
        /// <summary>
        /// This version is not obsolete for use in new packet core control plane deployments.
        /// Serialized Name: ObsoleteVersion.NotObsolete
        /// </summary>
        public static MobileNetworkObsoleteVersion NotObsolete { get; } = new MobileNetworkObsoleteVersion(NotObsoleteValue);
        /// <summary> Determines if two <see cref="MobileNetworkObsoleteVersion"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkObsoleteVersion left, MobileNetworkObsoleteVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkObsoleteVersion"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkObsoleteVersion left, MobileNetworkObsoleteVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkObsoleteVersion"/>. </summary>
        public static implicit operator MobileNetworkObsoleteVersion(string value) => new MobileNetworkObsoleteVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkObsoleteVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkObsoleteVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
