// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Type of managed service identity (currently only UserAssigned allowed).
    /// Serialized Name: ManagedServiceIdentityType
    /// </summary>
    public readonly partial struct MobileNetworkManagedServiceIdentityType : IEquatable<MobileNetworkManagedServiceIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkManagedServiceIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkManagedServiceIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary>
        /// None
        /// Serialized Name: ManagedServiceIdentityType.None
        /// </summary>
        public static MobileNetworkManagedServiceIdentityType None { get; } = new MobileNetworkManagedServiceIdentityType(NoneValue);
        /// <summary>
        /// UserAssigned
        /// Serialized Name: ManagedServiceIdentityType.UserAssigned
        /// </summary>
        public static MobileNetworkManagedServiceIdentityType UserAssigned { get; } = new MobileNetworkManagedServiceIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="MobileNetworkManagedServiceIdentityType"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkManagedServiceIdentityType left, MobileNetworkManagedServiceIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkManagedServiceIdentityType"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkManagedServiceIdentityType left, MobileNetworkManagedServiceIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkManagedServiceIdentityType"/>. </summary>
        public static implicit operator MobileNetworkManagedServiceIdentityType(string value) => new MobileNetworkManagedServiceIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkManagedServiceIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkManagedServiceIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
