// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
    /// Serialized Name: LocalDiagnosticsAccessConfiguration
    /// </summary>
    public partial class MobileNetworkLocalDiagnosticsAccessConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkLocalDiagnosticsAccessConfiguration"/>. </summary>
        /// <param name="authenticationType">
        /// How to authenticate users who access local diagnostics APIs.
        /// Serialized Name: LocalDiagnosticsAccessConfiguration.authenticationType
        /// </param>
        public MobileNetworkLocalDiagnosticsAccessConfiguration(MobileNetworkAuthenticationType authenticationType)
        {
            AuthenticationType = authenticationType;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkLocalDiagnosticsAccessConfiguration"/>. </summary>
        /// <param name="authenticationType">
        /// How to authenticate users who access local diagnostics APIs.
        /// Serialized Name: LocalDiagnosticsAccessConfiguration.authenticationType
        /// </param>
        /// <param name="httpsServerCertificate">
        /// The HTTPS server TLS certificate used to secure local access to diagnostics.
        /// Serialized Name: LocalDiagnosticsAccessConfiguration.httpsServerCertificate
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkLocalDiagnosticsAccessConfiguration(MobileNetworkAuthenticationType authenticationType, MobileNetworkHttpsServerCertificate httpsServerCertificate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationType = authenticationType;
            HttpsServerCertificate = httpsServerCertificate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkLocalDiagnosticsAccessConfiguration"/> for deserialization. </summary>
        internal MobileNetworkLocalDiagnosticsAccessConfiguration()
        {
        }

        /// <summary>
        /// How to authenticate users who access local diagnostics APIs.
        /// Serialized Name: LocalDiagnosticsAccessConfiguration.authenticationType
        /// </summary>
        [WirePath("authenticationType")]
        public MobileNetworkAuthenticationType AuthenticationType { get; set; }
        /// <summary>
        /// The HTTPS server TLS certificate used to secure local access to diagnostics.
        /// Serialized Name: LocalDiagnosticsAccessConfiguration.httpsServerCertificate
        /// </summary>
        [WirePath("httpsServerCertificate")]
        public MobileNetworkHttpsServerCertificate HttpsServerCertificate { get; set; }
    }
}
