// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Interface properties
    /// Serialized Name: InterfaceProperties
    /// </summary>
    public partial class MobileNetworkInterfaceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkInterfaceProperties"/>. </summary>
        public MobileNetworkInterfaceProperties()
        {
            IPv4AddressList = new ChangeTrackingList<string>();
            BfdIPv4Endpoints = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkInterfaceProperties"/>. </summary>
        /// <param name="name">
        /// The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        /// Serialized Name: InterfaceProperties.name
        /// </param>
        /// <param name="ipv4Address">
        /// The IPv4 address.
        /// Serialized Name: InterfaceProperties.ipv4Address
        /// </param>
        /// <param name="ipv4Subnet">
        /// The IPv4 subnet.
        /// Serialized Name: InterfaceProperties.ipv4Subnet
        /// </param>
        /// <param name="ipv4Gateway">
        /// The default IPv4 gateway (router).
        /// Serialized Name: InterfaceProperties.ipv4Gateway
        /// </param>
        /// <param name="vlanId">
        /// VLAN identifier of the network interface. Example: 501.
        /// Serialized Name: InterfaceProperties.vlanId
        /// </param>
        /// <param name="ipv4AddressList">
        /// The list of IPv4 addresses, for a multi-node system.
        /// Serialized Name: InterfaceProperties.ipv4AddressList
        /// </param>
        /// <param name="bfdIPv4Endpoints">
        /// The IPv4 addresses of the endpoints to send BFD probes to.
        /// Serialized Name: InterfaceProperties.bfdIpv4Endpoints
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkInterfaceProperties(string name, string ipv4Address, string ipv4Subnet, string ipv4Gateway, int? vlanId, IList<string> ipv4AddressList, IList<string> bfdIPv4Endpoints, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IPv4Address = ipv4Address;
            IPv4Subnet = ipv4Subnet;
            IPv4Gateway = ipv4Gateway;
            VlanId = vlanId;
            IPv4AddressList = ipv4AddressList;
            BfdIPv4Endpoints = bfdIPv4Endpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        /// Serialized Name: InterfaceProperties.name
        /// </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary>
        /// The IPv4 address.
        /// Serialized Name: InterfaceProperties.ipv4Address
        /// </summary>
        [WirePath("ipv4Address")]
        public string IPv4Address { get; set; }
        /// <summary>
        /// The IPv4 subnet.
        /// Serialized Name: InterfaceProperties.ipv4Subnet
        /// </summary>
        [WirePath("ipv4Subnet")]
        public string IPv4Subnet { get; set; }
        /// <summary>
        /// The default IPv4 gateway (router).
        /// Serialized Name: InterfaceProperties.ipv4Gateway
        /// </summary>
        [WirePath("ipv4Gateway")]
        public string IPv4Gateway { get; set; }
        /// <summary>
        /// VLAN identifier of the network interface. Example: 501.
        /// Serialized Name: InterfaceProperties.vlanId
        /// </summary>
        [WirePath("vlanId")]
        public int? VlanId { get; set; }
        /// <summary>
        /// The list of IPv4 addresses, for a multi-node system.
        /// Serialized Name: InterfaceProperties.ipv4AddressList
        /// </summary>
        [WirePath("ipv4AddressList")]
        public IList<string> IPv4AddressList { get; }
        /// <summary>
        /// The IPv4 addresses of the endpoints to send BFD probes to.
        /// Serialized Name: InterfaceProperties.bfdIpv4Endpoints
        /// </summary>
        [WirePath("bfdIpv4Endpoints")]
        public IList<string> BfdIPv4Endpoints { get; }
    }
}
