// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The installation state of the packet core.
    /// Serialized Name: InstallationState
    /// </summary>
    public readonly partial struct MobileNetworkInstallationState : IEquatable<MobileNetworkInstallationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkInstallationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkInstallationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UninstalledValue = "Uninstalled";
        private const string InstallingValue = "Installing";
        private const string InstalledValue = "Installed";
        private const string UpdatingValue = "Updating";
        private const string UpgradingValue = "Upgrading";
        private const string UninstallingValue = "Uninstalling";
        private const string ReinstallingValue = "Reinstalling";
        private const string RollingBackValue = "RollingBack";
        private const string FailedValue = "Failed";

        /// <summary>
        /// The packet core is uninstalled.
        /// Serialized Name: InstallationState.Uninstalled
        /// </summary>
        public static MobileNetworkInstallationState Uninstalled { get; } = new MobileNetworkInstallationState(UninstalledValue);
        /// <summary>
        /// The packet core is installing.
        /// Serialized Name: InstallationState.Installing
        /// </summary>
        public static MobileNetworkInstallationState Installing { get; } = new MobileNetworkInstallationState(InstallingValue);
        /// <summary>
        /// The packet core is installed.
        /// Serialized Name: InstallationState.Installed
        /// </summary>
        public static MobileNetworkInstallationState Installed { get; } = new MobileNetworkInstallationState(InstalledValue);
        /// <summary>
        /// The packet core is updating its configuration.
        /// Serialized Name: InstallationState.Updating
        /// </summary>
        public static MobileNetworkInstallationState Updating { get; } = new MobileNetworkInstallationState(UpdatingValue);
        /// <summary>
        /// The packet core is upgrading to a different software version.
        /// Serialized Name: InstallationState.Upgrading
        /// </summary>
        public static MobileNetworkInstallationState Upgrading { get; } = new MobileNetworkInstallationState(UpgradingValue);
        /// <summary>
        /// The packet core is uninstalling.
        /// Serialized Name: InstallationState.Uninstalling
        /// </summary>
        public static MobileNetworkInstallationState Uninstalling { get; } = new MobileNetworkInstallationState(UninstallingValue);
        /// <summary>
        /// The packet core is reinstalling.
        /// Serialized Name: InstallationState.Reinstalling
        /// </summary>
        public static MobileNetworkInstallationState Reinstalling { get; } = new MobileNetworkInstallationState(ReinstallingValue);
        /// <summary>
        /// The packet core is rolling back to its previous version.
        /// Serialized Name: InstallationState.RollingBack
        /// </summary>
        public static MobileNetworkInstallationState RollingBack { get; } = new MobileNetworkInstallationState(RollingBackValue);
        /// <summary>
        /// The packet core is in failed state.
        /// Serialized Name: InstallationState.Failed
        /// </summary>
        public static MobileNetworkInstallationState Failed { get; } = new MobileNetworkInstallationState(FailedValue);
        /// <summary> Determines if two <see cref="MobileNetworkInstallationState"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkInstallationState left, MobileNetworkInstallationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkInstallationState"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkInstallationState left, MobileNetworkInstallationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkInstallationState"/>. </summary>
        public static implicit operator MobileNetworkInstallationState(string value) => new MobileNetworkInstallationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkInstallationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkInstallationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
