// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The installation state of the packet core.
    /// Serialized Name: Installation
    /// </summary>
    public partial class MobileNetworkInstallation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkInstallation"/>. </summary>
        public MobileNetworkInstallation()
        {
            Reasons = new ChangeTrackingList<MobileNetworkInstallationReason>();
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkInstallation"/>. </summary>
        /// <param name="desiredState">
        /// The desired installation state
        /// Serialized Name: Installation.desiredState
        /// </param>
        /// <param name="state">
        /// Installation state
        /// Serialized Name: Installation.state
        /// </param>
        /// <param name="reinstallRequired">
        /// Whether a reinstall of the packet core is required to pick up the latest configuration changes.
        /// Serialized Name: Installation.reinstallRequired
        /// </param>
        /// <param name="reasons">
        /// Reason(s) for the current installation state of the packet core.
        /// Serialized Name: Installation.reasons
        /// </param>
        /// <param name="operation">
        /// A reference to an in-progress installation operation
        /// Serialized Name: Installation.operation
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkInstallation(DesiredInstallationState? desiredState, MobileNetworkInstallationState? state, MobileNetworkReinstallRequired? reinstallRequired, IReadOnlyList<MobileNetworkInstallationReason> reasons, SubResource operation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DesiredState = desiredState;
            State = state;
            ReinstallRequired = reinstallRequired;
            Reasons = reasons;
            Operation = operation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The desired installation state
        /// Serialized Name: Installation.desiredState
        /// </summary>
        [WirePath("desiredState")]
        public DesiredInstallationState? DesiredState { get; set; }
        /// <summary>
        /// Installation state
        /// Serialized Name: Installation.state
        /// </summary>
        [WirePath("state")]
        public MobileNetworkInstallationState? State { get; }
        /// <summary>
        /// Whether a reinstall of the packet core is required to pick up the latest configuration changes.
        /// Serialized Name: Installation.reinstallRequired
        /// </summary>
        [WirePath("reinstallRequired")]
        public MobileNetworkReinstallRequired? ReinstallRequired { get; }
        /// <summary>
        /// Reason(s) for the current installation state of the packet core.
        /// Serialized Name: Installation.reasons
        /// </summary>
        [WirePath("reasons")]
        public IReadOnlyList<MobileNetworkInstallationReason> Reasons { get; }
        /// <summary>
        /// A reference to an in-progress installation operation
        /// Serialized Name: Installation.operation
        /// </summary>
        internal SubResource Operation { get; }
        /// <summary> Gets Id. </summary>
        [WirePath("operation.id")]
        public ResourceIdentifier OperationId
        {
            get => Operation?.Id;
        }
    }
}
