// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The next hop in an IPv4 route.
    /// Serialized Name: Ipv4RouteNextHop
    /// </summary>
    public partial class MobileNetworkIPv4RouteNextHop
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkIPv4RouteNextHop"/>. </summary>
        public MobileNetworkIPv4RouteNextHop()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkIPv4RouteNextHop"/>. </summary>
        /// <param name="address">
        /// The next hop address.
        /// Serialized Name: Ipv4RouteNextHop.address
        /// </param>
        /// <param name="priority">
        /// The priority of this next hop. Next hops with lower preference values are preferred.
        /// Serialized Name: Ipv4RouteNextHop.priority
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkIPv4RouteNextHop(string address, int? priority, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Address = address;
            Priority = priority;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The next hop address.
        /// Serialized Name: Ipv4RouteNextHop.address
        /// </summary>
        [WirePath("address")]
        public string Address { get; set; }
        /// <summary>
        /// The priority of this next hop. Next hops with lower preference values are preferred.
        /// Serialized Name: Ipv4RouteNextHop.priority
        /// </summary>
        [WirePath("priority")]
        public int? Priority { get; set; }
    }
}
