// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// HTTPS server certificate configuration.
    /// Serialized Name: HttpsServerCertificate
    /// </summary>
    public partial class MobileNetworkHttpsServerCertificate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkHttpsServerCertificate"/>. </summary>
        /// <param name="certificateUri">
        /// The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
        /// Serialized Name: HttpsServerCertificate.certificateUrl
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="certificateUri"/> is null. </exception>
        public MobileNetworkHttpsServerCertificate(Uri certificateUri)
        {
            Argument.AssertNotNull(certificateUri, nameof(certificateUri));

            CertificateUri = certificateUri;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkHttpsServerCertificate"/>. </summary>
        /// <param name="certificateUri">
        /// The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
        /// Serialized Name: HttpsServerCertificate.certificateUrl
        /// </param>
        /// <param name="provisioning">
        /// The provisioning state of the certificate.
        /// Serialized Name: HttpsServerCertificate.provisioning
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkHttpsServerCertificate(Uri certificateUri, MobileNetworkCertificateProvisioning provisioning, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertificateUri = certificateUri;
            Provisioning = provisioning;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkHttpsServerCertificate"/> for deserialization. </summary>
        internal MobileNetworkHttpsServerCertificate()
        {
        }

        /// <summary>
        /// The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
        /// Serialized Name: HttpsServerCertificate.certificateUrl
        /// </summary>
        [WirePath("certificateUrl")]
        public Uri CertificateUri { get; set; }
        /// <summary>
        /// The provisioning state of the certificate.
        /// Serialized Name: HttpsServerCertificate.provisioning
        /// </summary>
        [WirePath("provisioning")]
        public MobileNetworkCertificateProvisioning Provisioning { get; }
    }
}
