// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The status of the diagnostics package collection.
    /// Serialized Name: DiagnosticsPackageStatus
    /// </summary>
    public readonly partial struct MobileNetworkDiagnosticsPackageStatus : IEquatable<MobileNetworkDiagnosticsPackageStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkDiagnosticsPackageStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkDiagnosticsPackageStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string CollectingValue = "Collecting";
        private const string CollectedValue = "Collected";
        private const string ErrorValue = "Error";

        /// <summary>
        /// NotStarted
        /// Serialized Name: DiagnosticsPackageStatus.NotStarted
        /// </summary>
        public static MobileNetworkDiagnosticsPackageStatus NotStarted { get; } = new MobileNetworkDiagnosticsPackageStatus(NotStartedValue);
        /// <summary>
        /// Collecting
        /// Serialized Name: DiagnosticsPackageStatus.Collecting
        /// </summary>
        public static MobileNetworkDiagnosticsPackageStatus Collecting { get; } = new MobileNetworkDiagnosticsPackageStatus(CollectingValue);
        /// <summary>
        /// Collected
        /// Serialized Name: DiagnosticsPackageStatus.Collected
        /// </summary>
        public static MobileNetworkDiagnosticsPackageStatus Collected { get; } = new MobileNetworkDiagnosticsPackageStatus(CollectedValue);
        /// <summary>
        /// Error
        /// Serialized Name: DiagnosticsPackageStatus.Error
        /// </summary>
        public static MobileNetworkDiagnosticsPackageStatus Error { get; } = new MobileNetworkDiagnosticsPackageStatus(ErrorValue);
        /// <summary> Determines if two <see cref="MobileNetworkDiagnosticsPackageStatus"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkDiagnosticsPackageStatus left, MobileNetworkDiagnosticsPackageStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkDiagnosticsPackageStatus"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkDiagnosticsPackageStatus left, MobileNetworkDiagnosticsPackageStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkDiagnosticsPackageStatus"/>. </summary>
        public static implicit operator MobileNetworkDiagnosticsPackageStatus(string value) => new MobileNetworkDiagnosticsPackageStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkDiagnosticsPackageStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkDiagnosticsPackageStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
