// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// Certificate provisioning state
    /// Serialized Name: CertificateProvisioning
    /// </summary>
    public partial class MobileNetworkCertificateProvisioning
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkCertificateProvisioning"/>. </summary>
        internal MobileNetworkCertificateProvisioning()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MobileNetworkCertificateProvisioning"/>. </summary>
        /// <param name="state">
        /// The certificate's provisioning state
        /// Serialized Name: CertificateProvisioning.state
        /// </param>
        /// <param name="reason">
        /// Reason for certificate provisioning failure.
        /// Serialized Name: CertificateProvisioning.reason
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MobileNetworkCertificateProvisioning(CertificateProvisioningState? state, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The certificate's provisioning state
        /// Serialized Name: CertificateProvisioning.state
        /// </summary>
        [WirePath("state")]
        public CertificateProvisioningState? State { get; }
        /// <summary>
        /// Reason for certificate provisioning failure.
        /// Serialized Name: CertificateProvisioning.reason
        /// </summary>
        [WirePath("reason")]
        public string Reason { get; }
    }
}
