// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// How to authenticate users who access local diagnostics APIs.
    /// Serialized Name: AuthenticationType
    /// </summary>
    public readonly partial struct MobileNetworkAuthenticationType : IEquatable<MobileNetworkAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobileNetworkAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobileNetworkAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AadValue = "AAD";
        private const string PasswordValue = "Password";

        /// <summary>
        /// Use AAD SSO to authenticate the user (this requires internet access).
        /// Serialized Name: AuthenticationType.AAD
        /// </summary>
        public static MobileNetworkAuthenticationType Aad { get; } = new MobileNetworkAuthenticationType(AadValue);
        /// <summary>
        /// Use locally stored passwords to authenticate the user.
        /// Serialized Name: AuthenticationType.Password
        /// </summary>
        public static MobileNetworkAuthenticationType Password { get; } = new MobileNetworkAuthenticationType(PasswordValue);
        /// <summary> Determines if two <see cref="MobileNetworkAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(MobileNetworkAuthenticationType left, MobileNetworkAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobileNetworkAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(MobileNetworkAuthenticationType left, MobileNetworkAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobileNetworkAuthenticationType"/>. </summary>
        public static implicit operator MobileNetworkAuthenticationType(string value) => new MobileNetworkAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobileNetworkAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobileNetworkAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
