// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MobileNetwork.Models
{
    /// <summary>
    /// The provisioning state of the private keys for SUPI concealment.
    /// Serialized Name: HomeNetworkPrivateKeysProvisioningState
    /// </summary>
    public readonly partial struct HomeNetworkPrivateKeysProvisioningState : IEquatable<HomeNetworkPrivateKeysProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HomeNetworkPrivateKeysProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HomeNetworkPrivateKeysProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotProvisionedValue = "NotProvisioned";
        private const string ProvisionedValue = "Provisioned";
        private const string FailedValue = "Failed";

        /// <summary>
        /// Provisioning of the private keys for SUPI concealment has not been attempted.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioningState.NotProvisioned
        /// </summary>
        public static HomeNetworkPrivateKeysProvisioningState NotProvisioned { get; } = new HomeNetworkPrivateKeysProvisioningState(NotProvisionedValue);
        /// <summary>
        /// The private keys for SUPI concealment are successfully provisioned.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioningState.Provisioned
        /// </summary>
        public static HomeNetworkPrivateKeysProvisioningState Provisioned { get; } = new HomeNetworkPrivateKeysProvisioningState(ProvisionedValue);
        /// <summary>
        /// Provisioning of the private keys for SUPI concealment has failed.
        /// Serialized Name: HomeNetworkPrivateKeysProvisioningState.Failed
        /// </summary>
        public static HomeNetworkPrivateKeysProvisioningState Failed { get; } = new HomeNetworkPrivateKeysProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="HomeNetworkPrivateKeysProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HomeNetworkPrivateKeysProvisioningState left, HomeNetworkPrivateKeysProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HomeNetworkPrivateKeysProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HomeNetworkPrivateKeysProvisioningState left, HomeNetworkPrivateKeysProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HomeNetworkPrivateKeysProvisioningState"/>. </summary>
        public static implicit operator HomeNetworkPrivateKeysProvisioningState(string value) => new HomeNetworkPrivateKeysProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HomeNetworkPrivateKeysProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HomeNetworkPrivateKeysProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
